/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.elevators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Elevators
extends BasePack {
    private static final HashMap<UUID, Long> cooldown = new HashMap();
    private final HashSet<Material> elevatorBlocks = new HashSet();

    public Elevators() {
        super(TTPack.ELEVATORS, Material.ENDER_PEARL);
        for (String block : this.getConfig().getStringList("elevator-blocks")) {
            Material item = Material.matchMaterial((String)block);
            if (item == null || !item.isBlock()) continue;
            this.elevatorBlocks.add(item);
        }
    }

    @EventHandler
    public void onDrop(final PlayerDropItemEvent event) {
        if (!Permission.ELEVATOR_CREATE.check((CommandSender)event.getPlayer())) {
            return;
        }
        if (!event.getItemDrop().getItemStack().getType().toString().equalsIgnoreCase(this.getConfig().getString("activator"))) {
            return;
        }
        if (event.getItemDrop().getItemStack().getAmount() != 1) {
            return;
        }
        if (this.isElevator(event.getItemDrop().getLocation().add(0.0, -1.0, 0.0).getBlock())) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!Elevators.this.elevatorBlocks.contains(event.getItemDrop().getLocation().add(0.0, -1.0, 0.0).getBlock().getType())) {
                    return;
                }
                if (event.getItemDrop().getItemStack().getAmount() != 1) {
                    return;
                }
                event.getItemDrop().remove();
                Elevators.this.createElevator(event.getItemDrop().getLocation().add(0.0, -1.0, 0.0));
                if (event.getItemDrop().isDead()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 0L, 20L);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!this.elevatorBlocks.contains(event.getBlock().getType())) {
            return;
        }
        if (!this.isElevator(block)) {
            return;
        }
        for (Entity entity : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 1.0, 0.5), 0.4, 0.8, 0.4)) {
            if (block.getY() + 1 != entity.getLocation().getBlockY() || entity.getType() != EntityType.MARKER || !entity.getScoreboardTags().contains("elevator")) continue;
            entity.remove();
            event.getBlock().getDrops().add(new ItemStack(Material.ENDER_PEARL));
            return;
        }
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent event) {
        if (!Permission.ELEVATOR_USE.check((CommandSender)event.getPlayer())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.isOnCooldown(player)) {
            return;
        }
        this.setCooldown(player);
        Location loc = player.getLocation();
        if (player.isSneaking()) {
            return;
        }
        Block standingBlock = loc.add(0.0, -1.0, 0.0).getBlock();
        if (!this.isElevator(standingBlock)) {
            return;
        }
        Block elevatorSpot = this.findNextElevatorDown(standingBlock, standingBlock.getWorld().getMinHeight());
        if (elevatorSpot == null) {
            return;
        }
        player.teleportAsync(new Location(player.getWorld(), player.getLocation().getX(), (double)(elevatorSpot.getY() + 1), player.getLocation().getZ(), player.getLocation().getYaw(), player.getLocation().getPitch()));
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation().add(0.0, 1.0, 0.0), 20, -0.5, -0.5, -0.5, 4.0);
        if (!this.getConfig().getBoolean("play-sound")) {
            return;
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
    }

    @EventHandler
    public void onJump(PlayerMoveEvent e) {
        if (!Permission.ELEVATOR_USE.check((CommandSender)e.getPlayer())) {
            return;
        }
        Player player = e.getPlayer();
        if (this.isOnCooldown(player)) {
            return;
        }
        if (e.getPlayer().getVelocity().getY() < 0.1) {
            return;
        }
        e.getPlayer().getVelocity().getY();
        Location loc = player.getLocation();
        Block standingBlock = loc.add(0.0, -0.6, 0.0).getBlock();
        if (!this.isElevator(standingBlock)) {
            return;
        }
        Block elevatorSpot = this.findNextElevatorUp(standingBlock);
        if (elevatorSpot == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
            player.teleportAsync(new Location(loc.getWorld(), loc.getX(), (double)(elevatorSpot.getY() + 1), loc.getZ(), loc.getYaw(), loc.getPitch()));
            player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation().add(0.0, 1.0, 0.0), 20, -0.5, -0.5, -0.5, 4.0);
            if (!this.getConfig().getBoolean("play-sound")) {
                return;
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            this.setCooldown(player);
        }, 1L);
    }

    private void createElevator(Location loc) {
        Block block = loc.getBlock();
        Marker marker = (Marker)block.getWorld().spawnEntity(block.getLocation().add(0.5, 1.0, 0.5), EntityType.MARKER);
        marker.addScoreboardTag("elevator");
        loc.getWorld().spawnParticle(Particle.PORTAL, block.getLocation().add(0.5, 1.0, 0.5), 200, -0.5, -0.5, -0.5, -1.0);
    }

    private boolean isElevator(Block block) {
        for (Entity nearbyEntity : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 1.0, 0.5), 0.4, 0.4, 0.4)) {
            if (!nearbyEntity.getScoreboardTags().contains("elevator") || nearbyEntity.getType() != EntityType.MARKER) continue;
            return true;
        }
        return false;
    }

    private Block findNextElevatorDown(Block eBlock, int minY) {
        for (int i = (int)eBlock.getLocation().getY(); i >= minY; --i) {
            Block block = eBlock.getLocation().getWorld().getBlockAt(eBlock.getX(), i, eBlock.getZ());
            if (!this.checkBlock(eBlock, block)) continue;
            return block;
        }
        return null;
    }

    private Block findNextElevatorUp(Block eBlock) {
        Block next = null;
        for (int i = (int)eBlock.getLocation().getY(); i < eBlock.getWorld().getMaxHeight(); ++i) {
            Block block = eBlock.getLocation().getWorld().getBlockAt(eBlock.getX(), i, eBlock.getZ());
            if (!this.checkBlock(eBlock, block)) continue;
            next = block;
            return next;
        }
        return next;
    }

    private boolean checkBlock(Block b1, Block b2) {
        if (this.getConfig().getBoolean("require-same-type") && b2.getType() != b1.getType()) {
            return false;
        }
        if (b2.getY() == b1.getY()) {
            return false;
        }
        return this.isElevator(b2);
    }

    private boolean isOnCooldown(Player player) {
        if (cooldown.containsKey(player.getUniqueId())) {
            return cooldown.get(player.getUniqueId()) > System.currentTimeMillis();
        }
        return false;
    }

    private void setCooldown(Player player) {
        cooldown.put(player.getUniqueId(), System.currentTimeMillis() + 500L);
    }
}

