/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.fastleafdecay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;

public class FastLeafDecay
extends BasePack {
    private final List<Block> scheduledBlocks = new ArrayList<Block>();
    private static final List<BlockFace> NEIGHBORS = Arrays.asList(BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.DOWN);

    public FastLeafDecay() {
        super(TTPack.FAST_LEAF_DECAY, Material.OAK_LEAVES);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.onBlockRemove(event.getBlock(), this.getConfig().getLong("break-delay"));
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.onBlockRemove(event.getBlock(), this.getConfig().getLong("decay-delay"));
    }

    private void onBlockRemove(Block oldBlock, long delay) {
        if (!Tag.LOGS.isTagged((Keyed)oldBlock.getType()) && !Tag.LEAVES.isTagged((Keyed)oldBlock.getType())) {
            return;
        }
        Collections.shuffle(NEIGHBORS);
        for (BlockFace neighborFace : NEIGHBORS) {
            Leaves leaves;
            Block block = oldBlock.getRelative(neighborFace);
            if (!block.getType().toString().toLowerCase().contains("leaves") || (leaves = (Leaves)block.getBlockData()).isPersistent() || this.scheduledBlocks.contains(block)) continue;
            if (this.getConfig().getBoolean("one-by-one")) {
                if (this.scheduledBlocks.isEmpty()) {
                    TeaksTweaks.getInstance().getServer().getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), this::decayOne, delay);
                }
                this.scheduledBlocks.add(block);
            } else {
                TeaksTweaks.getInstance().getServer().getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> this.decay(block), delay);
            }
            this.scheduledBlocks.add(block);
        }
    }

    private boolean decay(Block block) {
        if (!this.scheduledBlocks.remove(block)) {
            return false;
        }
        if (!block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4)) {
            return false;
        }
        if (!Tag.LEAVES.isTagged((Keyed)block.getType())) {
            return false;
        }
        Leaves leaves = (Leaves)block.getBlockData();
        if (leaves.isPersistent()) {
            return false;
        }
        if (leaves.getDistance() < 7) {
            return false;
        }
        this.onBlockRemove(block, this.getConfig().getLong("decay-delay"));
        if (this.getConfig().getBoolean("spawn-particles")) {
            block.getWorld().spawnParticle(Particle.BLOCK, block.getLocation().add(0.5, 0.5, 0.5), 8, 0.2, 0.2, 0.2, 0.0, (Object)block.getType().createBlockData());
        }
        if (this.getConfig().getBoolean("play-sound")) {
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_GRASS_BREAK, SoundCategory.BLOCKS, 0.05f, 1.2f);
        }
        block.breakNaturally();
        return true;
    }

    private void decayOne() {
        boolean decayed = false;
        int loops = 0;
        while (loops++ <= 100000) {
            if (this.scheduledBlocks.isEmpty()) {
                return;
            }
            Block block = this.scheduledBlocks.getFirst();
            decayed = this.decay(block);
            if (!decayed) continue;
        }
        if (!this.scheduledBlocks.isEmpty()) {
            long delay = this.getConfig().getLong("decay-delay");
            if (delay <= 0L) {
                delay = 1L;
            }
            TeaksTweaks.getInstance().getServer().getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), this::decayOne, delay);
        }
    }
}

