/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.graves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.graves.GraveCreator;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.XPUtils;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import me.teakivy.teakstweaks.utils.customitems.TItem;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class Graves
extends BasePack {
    public Graves() {
        super(TTPack.GRAVES, Material.STONE_BRICK_WALL);
    }

    @Override
    public List<CustomItem> registerItems() {
        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
        ItemStack graveKey = new ItemStack(Material.TRIPWIRE_HOOK);
        ItemMeta keyMeta = graveKey.getItemMeta();
        MiniMessage mm = MiniMessage.miniMessage();
        keyMeta.displayName(mm.deserialize((Object)TranslationManager.getString(Config.getLanguage(), "graves.key.item_name")));
        graveKey.addUnsafeEnchantment(Enchantment.CHANNELING, 1);
        keyMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(mm.deserialize((Object)TranslationManager.getString(Config.getLanguage(), "graves.key.item_lore")));
        keyMeta.lore(lore);
        graveKey.setItemMeta(keyMeta);
        CustomItem key = new CustomItem("grave_key", graveKey);
        items.add(key);
        return items;
    }

    @EventHandler
    public void onInteract(PlayerInteractAtEntityEvent event) throws IOException {
        Entity entity = event.getRightClicked();
        if (!entity.getScoreboardTags().contains("grave")) {
            return;
        }
        if (this.ownsGrave(entity, event.getPlayer())) {
            String ownerItems;
            event.setCancelled(true);
            entity.remove();
            PersistentDataContainer data = entity.getPersistentDataContainer();
            if (data.has(Key.get("grave_owner_items"), PersistentDataType.STRING) && (ownerItems = (String)data.get(Key.get("grave_owner_items"), PersistentDataType.STRING)) != null) {
                for (ItemStack item : GraveCreator.deserializeItems(ownerItems)) {
                    Item itemE = entity.getWorld().dropItem(entity.getLocation().add(0.0, 2.0, 0.0), item);
                    if (event.getPlayer().isSneaking()) {
                        PersistentDataContainer iData = itemE.getPersistentDataContainer();
                        iData.set(Key.get("grave_item_owner_uuid"), PersistentDataType.STRING, (Object)event.getPlayer().getUniqueId().toString());
                    }
                    itemE.setPickupDelay(0);
                    itemE.setVelocity(new Vector(0, 0, 0));
                }
            }
            if (data.has(Key.get("grave_owner_xp"), PersistentDataType.INTEGER) && (Integer)data.get(Key.get("grave_owner_xp"), PersistentDataType.INTEGER) > 0) {
                ExperienceOrb orb = (ExperienceOrb)entity.getWorld().spawnEntity(entity.getLocation().add(0.0, 2.0, 0.0), EntityType.EXPERIENCE_ORB);
                orb.setExperience(((Integer)data.get(Key.get("grave_owner_xp"), PersistentDataType.INTEGER)).intValue());
            }
            return;
        }
        event.setCancelled(true);
        if (this.getConfig().getBoolean("allow-robbing") || this.holdingKey(event.getPlayer())) {
            String ownerItems;
            PersistentDataContainer data;
            entity.remove();
            if (this.holdingKey(event.getPlayer()) && !this.getConfig().getBoolean("allow-robbing") && event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                event.getPlayer().getInventory().remove(TItem.GRAVE_KEY.getItem());
            }
            if ((data = entity.getPersistentDataContainer()).has(Key.get("grave_owner_items"), PersistentDataType.STRING) && (ownerItems = (String)data.get(Key.get("grave_owner_items"), PersistentDataType.STRING)) != null) {
                for (ItemStack item : GraveCreator.deserializeItems(ownerItems)) {
                    Item itemE = entity.getWorld().dropItem(entity.getLocation().add(0.0, 2.0, 0.0), item);
                    itemE.setPickupDelay(0);
                    itemE.setVelocity(new Vector(0, 0, 0));
                }
            }
            if (data.has(Key.get("grave_owner_xp"), PersistentDataType.INTEGER) && (Integer)data.get(Key.get("grave_owner_xp"), PersistentDataType.INTEGER) > 0) {
                ExperienceOrb orb = (ExperienceOrb)entity.getWorld().spawnEntity(entity.getLocation().add(0.0, 2.0, 0.0), EntityType.EXPERIENCE_ORB);
                orb.setExperience(((Integer)data.get(Key.get("grave_owner_xp"), PersistentDataType.INTEGER)).intValue());
            }
            return;
        }
        event.getPlayer().sendMessage(this.getText("cant_rob_grave", new ComponentLike[0]));
        event.setCancelled(true);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().getScoreboardTags().contains("grave")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickUp(InventoryPickupItemEvent event) {
        UUID itemUUID;
        UUID playerUUID;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryHolder;
        if (event.getItem().getPersistentDataContainer().has(Key.get("grave_item_owner_uuid"), PersistentDataType.STRING) && (playerUUID = player.getUniqueId()) != (itemUUID = UUID.fromString((String)event.getItem().getPersistentDataContainer().get(Key.get("grave_item_owner_uuid"), PersistentDataType.STRING)))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) throws IOException {
        if (!(this.getConfig().getBoolean("generate-in-lava") || event.getEntity().getLocation().getBlock().getType() != Material.LAVA && event.getEntity().getLocation().getBlock().getType() != Material.LAVA_CAULDRON)) {
            return;
        }
        if (event.getEntity().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Player player = event.getEntity();
        if (player.getLevel() < this.getConfig().getInt("level-threshold")) {
            return;
        }
        if (!this.getConfig().getBoolean("creative-drops") && event.getEntity().getGameMode() == GameMode.CREATIVE) {
            event.getEntity().getInventory().clear();
            event.getEntity().setExp(0.0f);
            event.getEntity().setLevel(0);
        }
        if (!this.getConfig().getBoolean("allow-empty-graves") && event.getDrops().isEmpty()) {
            return;
        }
        if (!this.getConfig().getBoolean("creative-graves") && event.getEntity().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Location loc = GraveCreator.findGraveLocation(player.getLocation());
        if (loc == null) {
            return;
        }
        if (!GraveCreator.getAirTypes().contains(loc.getBlock().getType())) {
            loc.setY((double)loc.getWorld().getMaxHeight());
            loc = GraveCreator.findGraveLocation(loc);
        }
        int xp = 0;
        if (this.getConfig().getBoolean("hold-xp")) {
            xp = this.getConfig().getBoolean("keep-all-xp") ? XPUtils.getPlayerExp(player) : event.getDroppedExp();
        }
        GraveCreator.createGrave(loc, player, xp);
        if (this.getConfig().getBoolean("locatable")) {
            Component lastGrave = this.getText("last_grave", Graves.insert("x", (int)Math.floor(loc.getX())), Graves.insert("y", (int)Math.floor(loc.getY())), Graves.insert("z", (int)Math.floor(loc.getZ())), Graves.insert("world", loc.getWorld().getName()));
            player.sendMessage(lastGrave);
            PersistentDataContainer playerData = player.getPersistentDataContainer();
            playerData.set(Key.get("graves_last"), PersistentDataType.STRING, (Object)((int)Math.floor(loc.getX()) + "," + (int)Math.floor(loc.getY()) + "," + (int)Math.floor(loc.getZ()) + "," + loc.getWorld().getName()));
        }
        if (this.getConfig().getBoolean("hold-xp")) {
            event.setDroppedExp(0);
        }
        event.getDrops().clear();
    }

    public boolean ownsGrave(Entity entity, Player player) {
        PersistentDataContainer data = entity.getPersistentDataContainer();
        if (data.has(Key.get("grave_owner_uuid"), PersistentDataType.STRING)) {
            String ownerUUID = (String)data.get(Key.get("grave_owner_uuid"), PersistentDataType.STRING);
            return player.getUniqueId().toString().equals(ownerUUID);
        }
        return false;
    }

    public boolean holdingKey(Player player) {
        ItemStack graveKey = TItem.GRAVE_KEY.getItem();
        return player.getInventory().getItem(EquipmentSlot.HAND).isSimilar(graveKey);
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (this.holdingKey(event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

