/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.harderendprogression;

import java.util.Random;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;

public class HarderEndProgression
extends BasePack {
    public HarderEndProgression() {
        super(TTPack.HARDER_END_PROGRESSION, Material.ENDER_EYE);
    }

    @Override
    public void init() {
        super.init();
        this.setEyeOfEnderRecipe();
    }

    @EventHandler
    public void changeEyePosition(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)entity;
            int breakChance = this.getConfig().getInt("break-chance");
            enderSignal.setDropItem(breakChance <= new Random().nextInt(101));
        }
    }

    public void setEyeOfEnderRecipe() {
        ShapelessRecipe recipe;
        int difficultyLevel = this.getConfig().getInt("difficulty-level");
        switch (difficultyLevel) {
            case 3: {
                ShapelessRecipe shapelessRecipe = this.levelThreeRecipe();
                break;
            }
            case 2: {
                ShapelessRecipe shapelessRecipe = this.levelTwoRecipe();
                break;
            }
            case 1: {
                ShapelessRecipe shapelessRecipe = this.levelOneRecipe();
                break;
            }
            default: {
                ShapelessRecipe shapelessRecipe = recipe = null;
            }
        }
        if (recipe == null) {
            return;
        }
        this.addRecipe((Recipe)recipe);
    }

    public ShapelessRecipe generateNewEmptyRecipe() {
        Material eyeOfEnder = Material.ENDER_EYE;
        Bukkit.removeRecipe((NamespacedKey)NamespacedKey.minecraft((String)eyeOfEnder.toString().toLowerCase()));
        return new ShapelessRecipe(Key.get(eyeOfEnder.name().toLowerCase()), new ItemStack(eyeOfEnder, 1));
    }

    public ShapelessRecipe levelOneRecipe() {
        ShapelessRecipe recipe = this.generateNewEmptyRecipe();
        recipe.addIngredient(Material.WIND_CHARGE);
        recipe.addIngredient(Material.ENDER_PEARL);
        recipe.addIngredient(Material.BLAZE_POWDER);
        return recipe;
    }

    public ShapelessRecipe levelTwoRecipe() {
        ShapelessRecipe recipe = this.generateNewEmptyRecipe();
        recipe.addIngredient(Material.PRISMARINE_SHARD);
        recipe.addIngredient(Material.WIND_CHARGE);
        recipe.addIngredient(Material.ENDER_PEARL);
        recipe.addIngredient(Material.BLAZE_POWDER);
        recipe.addIngredient(Material.AMETHYST_SHARD);
        return recipe;
    }

    public ShapelessRecipe levelThreeRecipe() {
        ShapelessRecipe recipe = this.generateNewEmptyRecipe();
        recipe.addIngredient(Material.PRISMARINE_SHARD);
        recipe.addIngredient(Material.PHANTOM_MEMBRANE);
        recipe.addIngredient(Material.GHAST_TEAR);
        recipe.addIngredient(Material.WIND_CHARGE);
        recipe.addIngredient(Material.ENDER_PEARL);
        recipe.addIngredient(Material.BLAZE_POWDER);
        recipe.addIngredient(Material.RESIN_CLUMP);
        recipe.addIngredient(Material.AMETHYST_SHARD);
        recipe.addIngredient(Material.ECHO_SHARD);
        return recipe;
    }
}

