/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.homes;

import java.util.UUID;
import me.teakivy.teakstweaks.packs.homes.Homes;
import me.teakivy.teakstweaks.utils.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class Home {
    private final String name;
    private final UUID owner;
    private final Location loc;

    public Home(String name, UUID owner, Location loc) {
        this.name = name;
        this.owner = owner;
        this.loc = loc;
    }

    public Home(String name, UUID owner, String locString) {
        this.name = name;
        this.owner = owner;
        String world = locString.split("world=")[1].split(";")[0];
        double x = Double.parseDouble(locString.split("x=")[1].split(";")[0]);
        double y = Double.parseDouble(locString.split("y=")[1].split(";")[0]);
        double z = Double.parseDouble(locString.split("z=")[1].split(";")[0]);
        float yaw = Float.parseFloat(locString.split("yaw=")[1].split(";")[0]);
        float pitch = Float.parseFloat(locString.split("pitch=")[1].split(";")[0]);
        this.loc = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Location getLoc() {
        return this.loc;
    }

    public String getLocString() {
        return "world=" + this.loc.getWorld().getName() + ";x=" + this.loc.getX() + ";y=" + this.loc.getY() + ";z=" + this.loc.getZ() + ";yaw=" + this.loc.getYaw() + ";pitch=" + this.loc.getPitch();
    }

    public void teleport() {
        Player player = Bukkit.getPlayer((UUID)this.owner);
        if (player == null) {
            return;
        }
        if (Homes.onCooldown(player)) {
            player.sendMessage((Component)Component.translatable((String)"homes.error.on_cooldown", (ComponentLike[])new ComponentLike[]{Argument.numeric((String)"time", (Number)Homes.getCooldown(player))}));
            return;
        }
        player.teleportAsync(this.loc);
        player.sendMessage((Component)Component.translatable((String)"homes.teleported", (ComponentLike[])new ComponentLike[]{Argument.string((String)"home", (String)this.name)}));
    }

    public void delete() {
        NamespacedKey key;
        Player player = Bukkit.getPlayer((UUID)this.owner);
        if (player == null) {
            return;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        String homes = (String)data.get(key = Key.get("homes"), PersistentDataType.STRING);
        if (homes == null) {
            return;
        }
        String[] homesArray = homes.split(",");
        StringBuilder newHomes = new StringBuilder();
        for (String home : homesArray) {
            if (home.equals(this.name)) continue;
            newHomes.append(home).append(",");
        }
        data.set(key, PersistentDataType.STRING, (Object)newHomes.toString());
        data.remove(Key.get("home." + this.name));
    }
}

