/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.homes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.homes.Home;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class Homes
extends BasePack {
    private static final List<Home> homes = new ArrayList<Home>();
    private static final HashMap<UUID, Long> cooldowns = new HashMap();

    public Homes() {
        super(TTPack.HOMES, Material.RECOVERY_COMPASS);
    }

    @Override
    public void init() {
        super.init();
        for (Player player : TeaksTweaks.getInstance().getServer().getOnlinePlayers()) {
            Homes.loadHomes(player);
        }
    }

    public static boolean setHome(Player player, String name, Location loc) {
        if (Homes.getHome(player, name) != null) {
            return false;
        }
        if (!Homes.checkName(name)) {
            return false;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        NamespacedKey key = Key.get("homes");
        Object homeString = (String)data.get(key, PersistentDataType.STRING);
        homeString = (String)homeString + "," + name;
        data.set(key, PersistentDataType.STRING, homeString);
        NamespacedKey key2 = Key.get("home." + name);
        Home home = new Home(name, player.getUniqueId(), loc);
        data.set(key2, PersistentDataType.STRING, (Object)home.getLocString());
        homes.add(home);
        return true;
    }

    public static boolean removeHome(Player player, String name) {
        Home home = Homes.getHome(player, name);
        if (home == null) {
            return false;
        }
        home.delete();
        homes.remove(home);
        return true;
    }

    public static Home getHome(Player player, String name) {
        for (Home home : homes) {
            if (!home.getName().equalsIgnoreCase(name) || !home.getOwner().equals(player.getUniqueId())) continue;
            return home;
        }
        return null;
    }

    public static List<Home> getHomes(Player player) {
        ArrayList<Home> playerHomes = new ArrayList<Home>();
        for (Home home : homes) {
            if (!home.getOwner().equals(player.getUniqueId())) continue;
            playerHomes.add(home);
        }
        return playerHomes;
    }

    public static boolean onCooldown(Player player) {
        return Homes.getCooldown(player) > 0;
    }

    public static int getCooldown(Player player) {
        long cooldownTime = (long)Config.getInt("packs.homes.teleport-cooldown") * 1000L;
        if (!cooldowns.containsKey(player.getUniqueId())) {
            return 0;
        }
        long timeLeft = cooldowns.get(player.getUniqueId()) + cooldownTime - System.currentTimeMillis();
        return (int)timeLeft / 1000;
    }

    public static void loadHomes(Player player) {
        String[] homes;
        NamespacedKey key;
        PersistentDataContainer data = player.getPersistentDataContainer();
        String homeString = (String)data.get(key = Key.get("homes"), PersistentDataType.STRING);
        if (homeString == null) {
            return;
        }
        for (String home : homes = homeString.split(",")) {
            NamespacedKey key2 = Key.get("home." + home);
            String locString = (String)data.get(key2, PersistentDataType.STRING);
            if (locString == null) continue;
            Home home1 = new Home(home, player.getUniqueId(), locString);
            Homes.homes.add(home1);
        }
    }

    public static void unloadHomes(Player player) {
        List<Home> playerHomes = Homes.getHomes(player);
        for (Home home : playerHomes) {
            homes.remove(home);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Homes.loadHomes(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Homes.unloadHomes(event.getPlayer());
    }

    private static boolean checkName(String name) {
        char[] allowedChars = "abcdefghijklmnopqrstuvwxyz1234567890_-".toCharArray();
        if (name.equalsIgnoreCase("bed")) {
            return false;
        }
        for (char c : name.toCharArray()) {
            boolean allowed = false;
            for (char allowedChar : allowedChars) {
                if (c != allowedChar) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            return false;
        }
        return true;
    }
}

