/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.infestedvillagers;

import java.util.Random;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class InfestedVillagers
extends BasePack {
    public InfestedVillagers() {
        super(TTPack.INFESTED_VILLAGERS, Material.ZOMBIE_VILLAGER_SPAWN_EGG);
    }

    @EventHandler
    public void onInfestation(EntityPotionEffectEvent event) {
        if (event.getEntityType() != EntityType.VILLAGER) {
            return;
        }
        if (event.getNewEffect() == null) {
            return;
        }
        if (event.getNewEffect().getType() != PotionEffectType.INFESTED) {
            return;
        }
        Villager entity = (Villager)event.getEntity();
        long seed = ((World)Bukkit.getWorlds().getFirst()).getSeed();
        long max = this.getConfig().getLong("max-time") * 20L;
        long min = this.getConfig().getLong("min-time") * 20L;
        long timer = new Random(seed).nextLong(max - min + 1L) + min;
        entity.shakeHead();
        this.shakeAfter(entity, timer);
    }

    public void shakeAfter(Villager villager, long delay) {
        if (delay <= 0L) {
            if (villager.isDead()) {
                return;
            }
            villager.zombify();
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> {
            if (villager.isDead()) {
                return;
            }
            villager.shakeHead();
            villager.removePotionEffect(PotionEffectType.INFESTED);
            this.shakeAfter(villager, delay - 20L);
        }, 20L);
    }
}

