/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.instamine;

import java.util.HashSet;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InstaMine
extends BasePack {
    private final HashSet<Material> instaMineBlocks = new HashSet();

    public InstaMine() {
        super(TTPack.INSTA_MINE, Material.DEEPSLATE);
        for (String block : this.getConfig().getStringList("blocks")) {
            Material item = Material.matchMaterial((String)block);
            if (item == null || !item.isBlock()) continue;
            this.instaMineBlocks.add(item);
        }
    }

    @EventHandler
    public void onBeginBreak(BlockDamageEvent e) {
        if (!Permission.INSTA_MINE.check((CommandSender)e.getPlayer())) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack item = e.getItemInHand();
        Block block = e.getBlock();
        if (!this.instaMineBlocks.contains(block.getType())) {
            return;
        }
        if (item.getType().equals((Object)Material.NETHERITE_PICKAXE) && this.hasHasteTwo(player) && this.isEfficiencyFive(item)) {
            e.setInstaBreak(true);
            player.playSound(block.getLocation(), block.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
        }
    }

    private boolean hasHasteTwo(Player player) {
        PotionEffect potion = player.getPotionEffect(PotionEffectType.HASTE);
        if (potion == null) {
            return false;
        }
        return potion.getAmplifier() >= 1;
    }

    private boolean isEfficiencyFive(ItemStack item) {
        return item.getItemMeta().getEnchantLevel(Enchantment.EFFICIENCY) >= 5;
    }
}

