/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.itemaverages;

import java.util.ArrayList;
import java.util.HashMap;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemAverages
extends BasePack {
    public static boolean inUse = false;
    public static Location tracking = null;
    private static boolean shouldStop = false;
    static ArrayList<Entity> itemsTracked = new ArrayList();
    static HashMap<Material, Integer> items = new HashMap();

    public ItemAverages() {
        super(TTPack.ITEM_AVERAGES, Material.HOPPER);
    }

    public static void spawnTracker(Location loc, Player player) {
        ItemAverages.glowingBlock(loc, 2400);
        ItemAverages.startTracker(player);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().getScoreboardTags().contains("tracker")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity().getScoreboardTags().contains("tracker")) {
            event.getDrops().clear();
        }
    }

    public static void startTracker(Player player) {
        ItemAverages.trackItems(player);
    }

    public static void trackItems(Player player) {
        for (Entity entity : tracking.getWorld().getEntities()) {
            if (entity.getType() != EntityType.ITEM || !(entity.getLocation().getBlock().getLocation().distanceSquared(tracking) < 1.0) || itemsTracked.contains(entity) || !(entity instanceof Item)) continue;
            ItemStack item = ((Item)entity).getItemStack();
            itemsTracked.add(entity);
            if (!items.containsKey(item.getType())) {
                items.put(item.getType(), item.getAmount());
                continue;
            }
            items.put(item.getType(), items.get(item.getType()) + item.getAmount());
        }
        if (!shouldStop) {
            Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> ItemAverages.trackItems(player), 1L);
            return;
        }
        shouldStop = false;
        inUse = false;
        tracking = null;
        ItemAverages.sendTotaledMessage(player, items);
        itemsTracked = new ArrayList();
        items = new HashMap();
    }

    private static void sendTotaledMessage(Player player, HashMap<Material, Integer> items) {
        HashMap<Material, Integer> totalItems = new HashMap<Material, Integer>();
        items.forEach((item, amount) -> totalItems.put((Material)item, amount * 30));
        if (!totalItems.isEmpty()) {
            player.sendMessage(ItemAverages.newText("<dark_gray>-------------------------", new TagResolver[0]));
            player.sendMessage((Component)Component.translatable((String)"item_averages.source_production"));
            totalItems.forEach((item, amount) -> player.sendMessage((Component)Component.translatable((String)"item_averages.item", (ComponentLike[])new ComponentLike[]{ItemAverages.insert("amount", amount), ItemAverages.insert("item", item.toString().toLowerCase().replace("_", " "))})));
            player.sendMessage(ItemAverages.newText("<dark_gray>-------------------------", new TagResolver[0]));
        } else {
            player.sendMessage(ItemAverages.newText("<dark_gray>-------------------------", new TagResolver[0]));
            player.sendMessage((Component)Component.translatable((String)"item_averages.no_items"));
            player.sendMessage(ItemAverages.newText("<dark_gray>-------------------------", new TagResolver[0]));
        }
    }

    public static void glowingBlock(Location loc, int glowLength) {
        LivingEntity entity = (LivingEntity)loc.getWorld().spawnEntity(loc.getBlock().getLocation().add(0.5, 0.0, 0.5), EntityType.MAGMA_CUBE);
        MagmaCube cube = (MagmaCube)entity;
        cube.setSize(2);
        entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, glowLength, 0, true, false));
        entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, glowLength, 0, true, false));
        entity.setAI(false);
        entity.setInvulnerable(true);
        entity.addScoreboardTag("tracker");
        inUse = true;
        tracking = loc.getBlock().getLocation();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TeaksTweaks.getInstance(), () -> {
            entity.remove();
            Logger.info((Component)Component.translatable((String)"item_averages.log_finish"));
            shouldStop = true;
        }, (long)glowLength);
    }
}

