/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.largerphantoms;

import java.util.Objects;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class LargerPhantoms
extends BasePack {
    public LargerPhantoms() {
        super(TTPack.LARGER_PHANTOMS, Material.PHANTOM_SPAWN_EGG);
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getType() != EntityType.PHANTOM || event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL && !Config.isDevMode()) {
            return;
        }
        Phantom phantom = (Phantom)entity;
        Player player = null;
        double distance = 2.147483647E9;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld().getUID() != Objects.requireNonNull(event.getLocation().getWorld()).getUID() || !(p.getLocation().distanceSquared(event.getLocation()) < distance)) continue;
            player = p;
            distance = p.getLocation().distanceSquared(event.getLocation());
        }
        if (player == null || distance > 1000.0) {
            return;
        }
        int lastSleepTicks = player.getStatistic(Statistic.TIME_SINCE_REST);
        if (lastSleepTicks < 144000) {
            return;
        }
        if (lastSleepTicks < 216000) {
            this.setPhantomAttributes(phantom, 3, 25, 1.0, 20, 15);
            return;
        }
        if (lastSleepTicks < 288000) {
            this.setPhantomAttributes(phantom, 5, 30, 1.3, 24, 17);
            return;
        }
        if (lastSleepTicks < 1728000) {
            this.setPhantomAttributes(phantom, 7, 35, 1.6, 28, 20);
            return;
        }
        this.setPhantomAttributes(phantom, 20, 100, 2.0, 50, 30);
    }

    public void setPhantomAttributes(Phantom phantom, int size, int maxHeath, double movementSpeed, int followRange, int attackDamage) {
        phantom.setSize(size);
        Objects.requireNonNull(phantom.getAttribute(Attribute.MAX_HEALTH)).setBaseValue((double)maxHeath);
        Objects.requireNonNull(phantom.getAttribute(Attribute.MOVEMENT_SPEED)).setBaseValue(movementSpeed);
        Objects.requireNonNull(phantom.getAttribute(Attribute.FOLLOW_RANGE)).setBaseValue((double)followRange);
        Objects.requireNonNull(phantom.getAttribute(Attribute.ATTACK_DAMAGE)).setBaseValue((double)attackDamage);
        phantom.setHealth((double)maxHeath);
    }
}

