/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.moremobheads.HeadRegister;
import me.teakivy.teakstweaks.packs.moremobheads.types.HeadDataLoader;
import me.teakivy.teakstweaks.packs.moremobheads.types.HeadEntry;
import me.teakivy.teakstweaks.packs.moremobheads.types.TexturedHead;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;

public class MoreMobHeads
extends BasePack {
    private static HashMap<String, HeadEntry> headData;

    public MoreMobHeads() {
        super(TTPack.MORE_MOB_HEADS, Material.ZOMBIE_HEAD);
    }

    @Override
    public void init() {
        super.init();
        headData = new HashMap();
        List<HeadEntry> heads = HeadDataLoader.loadHeadData();
        for (HeadEntry head : heads) {
            headData.put(head.key(), head);
        }
        HeadRegister.registerAll();
    }

    public static HashMap<String, HeadEntry> getHeadData() {
        return headData;
    }

    public static HeadEntry getHead(String key) {
        return headData.get(key);
    }

    public static boolean shouldDrop(Player player, String key) {
        double num;
        if (Config.isDevMode()) {
            return true;
        }
        HeadEntry entry = MoreMobHeads.getHead(key);
        if (entry == null) {
            throw new IllegalArgumentException("No head found for key: " + key);
        }
        double chance = entry.chance();
        double lootingBonus = entry.looting_bonus();
        Random rand = new Random();
        if (player == null) {
            return false;
        }
        if (player.getInventory().getItemInMainHand().getItemMeta() != null) {
            for (i = 0; i < player.getInventory().getItemInMainHand().getItemMeta().getEnchantLevel(Enchantment.LOOTING); ++i) {
                chance += lootingBonus;
            }
        } else if (player.getInventory().getItemInOffHand().getItemMeta() != null) {
            for (i = 0; i < player.getInventory().getItemInOffHand().getItemMeta().getEnchantLevel(Enchantment.LOOTING); ++i) {
                chance += lootingBonus;
            }
        }
        if (chance > 1.0) {
            chance = 1.0;
        }
        return (num = rand.nextDouble()) < chance;
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        return new URL(decoded.substring("{\"textures\":{\"SKIN\":{\"url\":\"".length(), decoded.length() - "\"}}}".length()));
    }

    public static ItemStack getHeadItem(String key, Sound sound) {
        HeadEntry entry = MoreMobHeads.getHead(key);
        if (entry == null) {
            return null;
        }
        if (!(entry instanceof TexturedHead)) {
            return null;
        }
        TexturedHead texturedHead = (TexturedHead)entry;
        String texture = texturedHead.texture();
        String n = texturedHead.name();
        return MoreMobHeads.createhead(texture, n, sound);
    }

    public static ItemStack createhead(String texture, String name, Sound sound) {
        ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD);
        PlayerProfile profile = Bukkit.createProfileExact((UUID)UUID.fromString("fdb5599c-1b14-440e-82df-d69719703d21"), (String)"MobHead");
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        Component n = MiniMessage.miniMessage().deserialize((Object)("<yellow>" + name)).decoration(TextDecoration.ITALIC, false);
        meta.displayName(n);
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(MoreMobHeads.getUrlFromBase64(texture));
        }
        catch (MalformedURLException ignored) {
            ignored.printStackTrace();
        }
        profile.setTextures(textures);
        meta.setPlayerProfile(profile);
        if (sound != null) {
            meta.setNoteBlockSound(Registry.SOUNDS.getKey((Keyed)sound));
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

