/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDeathEvent;

public class CatHead
extends AdvancedMobHead {
    public CatHead() {
        super(EntityType.CAT, Sound.ENTITY_CAT_HISS);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Cat cat = (Cat)event.getEntity();
        String type = switch (Objects.requireNonNull(CatType.fromType(cat.getCatType())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "calico";
            case 1 -> "jellie";
            case 2 -> "siamese";
            case 3 -> "persian";
            case 4 -> "british_shorthair";
            case 5 -> "tabby";
            case 6 -> "black";
            case 7 -> "red";
            case 8 -> "ragdoll";
            case 9 -> "white";
            case 10 -> "all_black";
        };
        return type + "_cat";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("calico", "jellie", "siamese", "persian", "british_shorthair", "tabby", "black", "red", "ragdoll", "white", "all_black");
        for (String key : keys) {
            new CustomItem(key + "_cat_head", this.getHead(key + "_cat")).register();
        }
    }

    protected static enum CatType {
        CALICO(Cat.Type.CALICO),
        JELLIE(Cat.Type.JELLIE),
        SIAMESE(Cat.Type.SIAMESE),
        PERSIAN(Cat.Type.PERSIAN),
        BRITISH_SHORTHAIR(Cat.Type.BRITISH_SHORTHAIR),
        TABBY(Cat.Type.TABBY),
        BLACK(Cat.Type.BLACK),
        RED(Cat.Type.RED),
        RAGDOLL(Cat.Type.RAGDOLL),
        WHITE(Cat.Type.WHITE),
        ALL_BLACK(Cat.Type.ALL_BLACK);

        private final Cat.Type type;

        private CatType(Cat.Type type) {
            this.type = type;
        }

        public Cat.Type getType() {
            return this.type;
        }

        public static CatType fromType(Cat.Type type) {
            for (CatType value : CatType.values()) {
                if (value.type != type) continue;
                return value;
            }
            return null;
        }
    }
}

