/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDeathEvent;

public class ChickenHead
extends AdvancedMobHead {
    public ChickenHead() {
        super(EntityType.CHICKEN, Sound.ENTITY_CHICKEN_AMBIENT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Chicken chicken = (Chicken)event.getEntity();
        String type = switch (Objects.requireNonNull(ChickenVariant.fromVariant(chicken.getVariant())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "warm";
            case 1 -> "temperate";
            case 2 -> "cold";
        };
        return type + "_chicken";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("warm", "temperate", "cold");
        for (String key : keys) {
            new CustomItem(key + "_chicken_head", this.getHead(key + "_chicken")).register();
        }
    }

    protected static enum ChickenVariant {
        WARM(Chicken.Variant.WARM),
        TEMPERATE(Chicken.Variant.TEMPERATE),
        COLD(Chicken.Variant.COLD);

        private final Chicken.Variant variant;

        private ChickenVariant(Chicken.Variant variant) {
            this.variant = variant;
        }

        public Chicken.Variant getVariant() {
            return this.variant;
        }

        public static ChickenVariant fromVariant(Chicken.Variant variant) {
            for (ChickenVariant value : ChickenVariant.values()) {
                if (value.variant != variant) continue;
                return value;
            }
            return null;
        }
    }
}

