/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import io.papermc.paper.world.WeatheringCopperState;
import java.util.List;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDeathEvent;

public class CopperGolemHead
extends AdvancedMobHead {
    public CopperGolemHead() {
        super(EntityType.COPPER_GOLEM, Sound.ENTITY_COPPER_GOLEM_SPIN);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        CopperGolem golem = (CopperGolem)event.getEntity();
        return switch (golem.getWeatheringState()) {
            default -> throw new MatchException(null, null);
            case WeatheringCopperState.UNAFFECTED -> "copper_golem";
            case WeatheringCopperState.EXPOSED -> "exposed_copper_golem";
            case WeatheringCopperState.WEATHERED -> "weathered_copper_golem";
            case WeatheringCopperState.OXIDIZED -> "oxidized_copper_golem";
        };
    }

    @Override
    protected Sound getSound(String key) {
        return switch (key) {
            case "exposed_copper_golem", "weathered_copper_golem" -> Sound.ENTITY_COPPER_GOLEM_WEATHERED_SPIN;
            case "oxidized_copper_golem" -> Sound.ENTITY_COPPER_GOLEM_OXIDIZED_SPIN;
            default -> Sound.ENTITY_COPPER_GOLEM_SPIN;
        };
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("copper_golem", "exposed_copper_golem", "weathered_copper_golem", "oxidized_copper_golem");
        for (String key : keys) {
            new CustomItem(key + "_head", this.getHead(key)).register();
        }
    }
}

