/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDeathEvent;

public class CowHead
extends AdvancedMobHead {
    public CowHead() {
        super(EntityType.COW, Sound.ENTITY_COW_AMBIENT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Cow cow = (Cow)event.getEntity();
        String type = switch (Objects.requireNonNull(CowVariant.fromVariant(cow.getVariant())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "warm";
            case 1 -> "temperate";
            case 2 -> "cold";
        };
        return type + "_cow";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("warm", "temperate", "cold");
        for (String key : keys) {
            new CustomItem(key + "_cow_head", this.getHead(key + "_cow")).register();
        }
    }

    protected static enum CowVariant {
        WARM(Cow.Variant.WARM),
        TEMPERATE(Cow.Variant.TEMPERATE),
        COLD(Cow.Variant.COLD);

        private final Cow.Variant variant;

        private CowVariant(Cow.Variant variant) {
            this.variant = variant;
        }

        public Cow.Variant getVariant() {
            return this.variant;
        }

        public static CowVariant fromVariant(Cow.Variant variant) {
            for (CowVariant value : CowVariant.values()) {
                if (value.variant != variant) continue;
                return value;
            }
            return null;
        }
    }
}

