/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.event.entity.EntityDeathEvent;

public class FrogHead
extends AdvancedMobHead {
    public FrogHead() {
        super(EntityType.FROG, Sound.ENTITY_FROG_TONGUE);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Frog frog = (Frog)event.getEntity();
        String type = switch (Objects.requireNonNull(FrogVariant.fromVariant(frog.getVariant())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "warm";
            case 1 -> "temperate";
            case 2 -> "cold";
        };
        return type + "_frog";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("warm", "temperate", "cold");
        for (String key : keys) {
            new CustomItem(key + "_frog_head", this.getHead(key + "_frog")).register();
        }
    }

    protected static enum FrogVariant {
        WARM(Frog.Variant.WARM),
        TEMPERATE(Frog.Variant.TEMPERATE),
        COLD(Frog.Variant.COLD);

        private final Frog.Variant variant;

        private FrogVariant(Frog.Variant variant) {
            this.variant = variant;
        }

        public Frog.Variant getVariant() {
            return this.variant;
        }

        public static FrogVariant fromVariant(Frog.Variant variant) {
            for (FrogVariant value : FrogVariant.values()) {
                if (value.variant != variant) continue;
                return value;
            }
            return null;
        }
    }
}

