/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;
import org.bukkit.event.entity.EntityDeathEvent;

public class PigHead
extends AdvancedMobHead {
    public PigHead() {
        super(EntityType.PIG, Sound.ENTITY_PIG_AMBIENT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Pig pig = (Pig)event.getEntity();
        String type = switch (Objects.requireNonNull(PigVariant.fromVariant(pig.getVariant())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "warm";
            case 1 -> "temperate";
            case 2 -> "cold";
        };
        return type + "_pig";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("warm", "temperate", "cold");
        for (String key : keys) {
            new CustomItem(key + "_pig_head", this.getHead(key + "_pig")).register();
        }
    }

    protected static enum PigVariant {
        WARM(Pig.Variant.WARM),
        TEMPERATE(Pig.Variant.TEMPERATE),
        COLD(Pig.Variant.COLD);

        private final Pig.Variant variant;

        private PigVariant(Pig.Variant variant) {
            this.variant = variant;
        }

        public Pig.Variant getVariant() {
            return this.variant;
        }

        public static PigVariant fromVariant(Pig.Variant variant) {
            for (PigVariant value : PigVariant.values()) {
                if (value.variant != variant) continue;
                return value;
            }
            return null;
        }
    }
}

