/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.entity.EntityDeathEvent;

public class RabbitHead
extends AdvancedMobHead {
    public RabbitHead() {
        super(EntityType.RABBIT, Sound.ENTITY_RABBIT_AMBIENT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Rabbit rabbit = (Rabbit)event.getEntity();
        if (rabbit.customName() != null && Objects.requireNonNull(rabbit.customName()).toString().toLowerCase().contains("toast")) {
            return "toast_rabbit";
        }
        String type = switch (rabbit.getRabbitType()) {
            default -> throw new MatchException(null, null);
            case Rabbit.Type.BROWN -> "brown";
            case Rabbit.Type.WHITE -> "white";
            case Rabbit.Type.BLACK -> "black";
            case Rabbit.Type.BLACK_AND_WHITE -> "black_white";
            case Rabbit.Type.GOLD -> "gold";
            case Rabbit.Type.SALT_AND_PEPPER -> "salt_pepper";
            case Rabbit.Type.THE_KILLER_BUNNY -> "killer";
        };
        return type + "_rabbit";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("toast", "brown", "white", "black", "black_white", "gold", "salt_pepper", "killer");
        for (String key : keys) {
            new CustomItem(key + "_rabbit_head", this.getHead(key + "_rabbit")).register();
        }
    }
}

