/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDeathEvent;

public class WolfHead
extends AdvancedMobHead {
    public WolfHead() {
        super(EntityType.WOLF, Sound.ENTITY_WOLF_CUTE_PANT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        Object type;
        Wolf wolf = (Wolf)event.getEntity();
        switch (Objects.requireNonNull(WolfVariant.fromVariant(wolf.getVariant())).ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object object = "ashen";
                break;
            }
            case 1: {
                Object object = "black";
                break;
            }
            case 2: {
                Object object = "chestnut";
                break;
            }
            case 3: {
                Object object = "pale";
                break;
            }
            case 4: {
                Object object = "rusty";
                break;
            }
            case 5: {
                Object object = "snowy";
                break;
            }
            case 6: {
                Object object = "spotted";
                break;
            }
            case 7: {
                Object object = "striped";
                break;
            }
            case 8: {
                Object object = type = "woods";
            }
        }
        if (wolf.isAngry()) {
            type = "angry_" + (String)type;
        }
        return (String)type + "_wolf";
    }

    @Override
    protected Sound getSound(String key) {
        return key.startsWith("angry_") ? Sound.ENTITY_WOLF_GROWL : Sound.ENTITY_WOLF_CUTE_PANT;
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("ashen", "black", "chestnut", "pale", "rusty", "snowy", "spotted", "striped", "woods");
        for (String key : keys) {
            new CustomItem(key + "_wolf_head", this.getHead(key + "_wolf")).register();
            new CustomItem("angry_" + key + "_wolf_head", this.getHead("angry_" + key + "_wolf")).register();
        }
    }

    protected static enum WolfVariant {
        ASHEN(Wolf.Variant.ASHEN),
        BLACK(Wolf.Variant.BLACK),
        CHESTNUT(Wolf.Variant.CHESTNUT),
        PALE(Wolf.Variant.PALE),
        RUSTY(Wolf.Variant.RUSTY),
        SNOWY(Wolf.Variant.SNOWY),
        SPOTTED(Wolf.Variant.SPOTTED),
        STRIPED(Wolf.Variant.STRIPED),
        WOODS(Wolf.Variant.WOODS);

        private final Wolf.Variant variant;

        private WolfVariant(Wolf.Variant variant) {
            this.variant = variant;
        }

        public Wolf.Variant getVariant() {
            return this.variant;
        }

        public static WolfVariant fromVariant(Wolf.Variant variant) {
            for (WolfVariant value : WolfVariant.values()) {
                if (value.variant != variant) continue;
                return value;
            }
            return null;
        }
    }
}

