/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.moremobheads.mobs.advanced;

import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.packs.moremobheads.abstractions.AdvancedMobHead;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityDeathEvent;

public class ZombieVillagerHead
extends AdvancedMobHead {
    public ZombieVillagerHead() {
        super(EntityType.ZOMBIE_VILLAGER, Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT);
    }

    @Override
    protected String getKey(EntityDeathEvent event) {
        ZombieVillager zombieVillager = (ZombieVillager)event.getEntity();
        String type = switch (Objects.requireNonNull(VillagerProfession.fromProfession(zombieVillager.getVillagerProfession())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "armorer";
            case 1 -> "butcher";
            case 2 -> "cartographer";
            case 3 -> "cleric";
            case 4 -> "farmer";
            case 5 -> "fisherman";
            case 6 -> "fletcher";
            case 7 -> "leatherworker";
            case 8 -> "librarian";
            case 9 -> "mason";
            case 10 -> "nitwit";
            case 11 -> "shepherd";
            case 12 -> "toolsmith";
            case 13 -> "weaponsmith";
            case 14 -> "unemployed";
        };
        return type + "_zombie_villager";
    }

    @Override
    protected void register() {
        super.register();
        List<String> keys = List.of("armorer", "butcher", "cartographer", "cleric", "farmer", "fisherman", "fletcher", "leatherworker", "librarian", "mason", "nitwit", "shepherd", "toolsmith", "weaponsmith", "unemployed");
        for (String key : keys) {
            new CustomItem(key + "_zombie_villager_head", this.getHead(key + "_zombie_villager")).register();
        }
    }

    protected static enum VillagerProfession {
        ARMORER(Villager.Profession.ARMORER),
        BUTCHER(Villager.Profession.BUTCHER),
        CARTOGRAPHER(Villager.Profession.CARTOGRAPHER),
        CLERIC(Villager.Profession.CLERIC),
        FARMER(Villager.Profession.FARMER),
        FISHERMAN(Villager.Profession.FISHERMAN),
        FLETCHER(Villager.Profession.FLETCHER),
        LEATHERWORKER(Villager.Profession.LEATHERWORKER),
        LIBRARIAN(Villager.Profession.LIBRARIAN),
        MASON(Villager.Profession.MASON),
        NITWIT(Villager.Profession.NITWIT),
        SHEPHERD(Villager.Profession.SHEPHERD),
        TOOLSMITH(Villager.Profession.TOOLSMITH),
        WEAPONSMITH(Villager.Profession.WEAPONSMITH),
        NONE(Villager.Profession.NONE);

        private final Villager.Profession profession;

        private VillagerProfession(Villager.Profession profession) {
            this.profession = profession;
        }

        public Villager.Profession getProfession() {
            return this.profession;
        }

        public static VillagerProfession fromProfession(Villager.Profession profession) {
            for (VillagerProfession value : VillagerProfession.values()) {
                if (value.profession != profession) continue;
                return value;
            }
            return null;
        }
    }
}

