/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.playerheaddrops;

import java.util.ArrayList;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerHeadDrops
extends BasePack {
    public PlayerHeadDrops() {
        super(TTPack.PLAYER_HEAD_DROPS, Material.PLAYER_HEAD);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!player.isDead()) {
            return;
        }
        if (player.getKiller() == null) {
            return;
        }
        Player killer = player.getKiller();
        event.getDrops().add(this.getHead(player, killer.getName()));
    }

    public ItemStack getHead(Player player, String killer) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta skull = (SkullMeta)item.getItemMeta();
        skull.setNoteBlockSound(Registry.SOUNDS.getKey((Keyed)Sound.ENTITY_PLAYER_HURT));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (this.getConfig().getBoolean("display-killer")) {
            lore.add(MiniMessage.miniMessage().deserialize((Object)TranslationManager.getString(Config.getLanguage(), "player_head_drops.lore").replace("\\<player>", killer)));
        }
        skull.lore(lore);
        skull.setOwningPlayer((OfflinePlayer)player);
        item.setItemMeta((ItemMeta)skull);
        return item;
    }
}

