/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.quickcommands;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.quickcommands.base.MenuQuickCommand;
import me.teakivy.teakstweaks.packs.quickcommands.base.TargetedQuickCommand;
import me.teakivy.teakstweaks.packs.quickcommands.commands.EnderChestQuickCommand;
import me.teakivy.teakstweaks.packs.quickcommands.commands.ReplyQuickCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MenuType;

public class QuickCommands
extends BasePack {
    public QuickCommands() {
        super(TTPack.QUICK_COMMANDS, Material.COMMAND_BLOCK);
    }

    @Override
    public void init() {
        super.init();
        if (this.getConfig().getBoolean("gamemode")) {
            this.registerGamemodeCommand("gms", GameMode.SURVIVAL, Permission.COMMAND_GMS);
            this.registerGamemodeCommand("gmc", GameMode.CREATIVE, Permission.COMMAND_GMC);
            this.registerGamemodeCommand("gma", GameMode.ADVENTURE, Permission.COMMAND_GMA);
            this.registerGamemodeCommand("gmsp", GameMode.SPECTATOR, Permission.COMMAND_GMSP);
        }
        if (this.getConfig().getBoolean("reply")) {
            new ReplyQuickCommand().register();
        }
        if (this.getConfig().getBoolean("enderchest")) {
            new EnderChestQuickCommand().register();
        }
        this.registerIfEnabled("feed", Permission.COMMAND_FEED, p -> {
            p.setFoodLevel(20);
            p.setSaturation(20.0f);
        });
        this.registerIfEnabled("heal", Permission.COMMAND_HEAL, p -> p.setHealth(p.getHealthScale()));
        this.registerIfEnabled("fly", Permission.COMMAND_FLY, p -> p.setAllowFlight(!p.getAllowFlight()));
        this.registerMenuCommands(Map.of("craftingtable", new MenuMeta(List.of("craft", "workbench", "wb"), Permission.COMMAND_CRAFTINGTABLE, (MenuType)MenuType.CRAFTING), "anvil", new MenuMeta(List.of(), Permission.COMMAND_ANVIL, (MenuType)MenuType.ANVIL), "cartographytable", new MenuMeta(List.of("cartography"), Permission.COMMAND_CARTOGRAPHYTABLE, (MenuType)MenuType.CARTOGRAPHY_TABLE), "grindstone", new MenuMeta(List.of(), Permission.COMMAND_GRINDSTONE, (MenuType)MenuType.GRINDSTONE), "loom", new MenuMeta(List.of(), Permission.COMMAND_LOOM, (MenuType)MenuType.LOOM), "smithingtable", new MenuMeta(List.of("smithing"), Permission.COMMAND_SMITHINGTABLE, (MenuType)MenuType.SMITHING), "stonecutter", new MenuMeta(List.of(), Permission.COMMAND_STONECUTTER, (MenuType)MenuType.STONECUTTER)));
    }

    private void registerGamemodeCommand(String name, GameMode mode, Permission permission) {
        new TargetedQuickCommand(name, permission, player -> player.setGameMode(mode)).register();
    }

    private void registerIfEnabled(String key, Permission permission, Consumer<Player> action) {
        if (this.getConfig().getBoolean(key)) {
            new TargetedQuickCommand(key, permission, action).register();
        }
    }

    private void registerMenuCommands(Map<String, MenuMeta> commands) {
        for (Map.Entry<String, MenuMeta> entry : commands.entrySet()) {
            String key = entry.getKey();
            MenuMeta meta = entry.getValue();
            if (!this.getConfig().getBoolean(key)) continue;
            new MenuQuickCommand(key, meta.aliases(), meta.permission(), meta.menuType()).register();
        }
    }

    private record MenuMeta(List<String> aliases, Permission permission, MenuType menuType) {
    }
}

