/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.quickcommands.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.entity.Player;

public class ReplyQuickCommand {
    private final HashMap<UUID, UUID> lastMessage = new HashMap();

    public void register() {
        new MessageCommand().register();
        new ReplyCommand().register();
    }

    public class MessageCommand
    extends AbstractCommand {
        public MessageCommand() {
            super(TTPack.QUICK_COMMANDS, "quick_commands.message", List.of("msg", "tell", "whisper", "w"));
        }

        @Override
        public LiteralCommandNode<CommandSourceStack> getCommand() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"message").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this.playerOnly(this::execute))))).build();
        }

        private int execute(CommandContext<CommandSourceStack> context) {
            Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
            try {
                Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
                String message = StringArgumentType.getString(context, (String)"message");
                target.sendMessage(this.getText("whisper_to_you", Argument.string((String)"player", (String)player.getName()), Argument.string((String)"message", (String)message)));
                player.sendMessage(this.getText("whisper_to_player", Argument.string((String)"player", (String)player.getName()), Argument.string((String)"message", (String)message)));
                ReplyQuickCommand.this.lastMessage.put(player.getUniqueId(), target.getUniqueId());
                ReplyQuickCommand.this.lastMessage.put(target.getUniqueId(), player.getUniqueId());
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            return 1;
        }
    }

    public class ReplyCommand
    extends AbstractCommand {
        public ReplyCommand() {
            super(TTPack.QUICK_COMMANDS, "quick_commands.reply", List.of("r"));
        }

        @Override
        public LiteralCommandNode<CommandSourceStack> getCommand() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reply").requires(this.perm(Permission.COMMAND_REPLY))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this.playerOnly(this::execute)))).build();
        }

        private int execute(CommandContext<CommandSourceStack> context) {
            Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
            String message = StringArgumentType.getString(context, (String)"message");
            UUID targetUUID = ReplyQuickCommand.this.lastMessage.get(player.getUniqueId());
            if (targetUUID == null) {
                player.sendMessage(this.getError("no_reply", new ComponentLike[0]));
                return 1;
            }
            Player target = player.getServer().getPlayer(targetUUID);
            if (target == null) {
                player.sendMessage(ErrorType.PLAYER_DNE.m());
                return 1;
            }
            target.sendMessage(this.get("quick_commands.message.whisper_to_you", Argument.string((String)"player", (String)player.getName()), Argument.string((String)"message", (String)message)));
            player.sendMessage(this.get("quick_commands.message.whisper_to_player", Argument.string((String)"player", (String)player.getName()), Argument.string((String)"message", (String)message)));
            ReplyQuickCommand.this.lastMessage.put(player.getUniqueId(), targetUUID);
            ReplyQuickCommand.this.lastMessage.put(targetUUID, player.getUniqueId());
            return 1;
        }
    }
}

