/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.rotationwrench;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import me.teakivy.teakstweaks.utils.customitems.TItem;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Piston;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class RotationWrench
extends BasePack {
    private final String resourcePackUrl = "https://drive.google.com/uc?export=download&id=1poeTqOmlGj0e40s1FSlop0lhuUNTxrVZ";
    private final byte[] hash = this.hexStringToByteArray("848afde4632d98f9db390a811737ff8f82374869");
    private final List<BlockFace> faces = Lists.newArrayList((Object[])new BlockFace[]{BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.UP, BlockFace.DOWN});

    private byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public RotationWrench() {
        super(TTPack.ROTATION_WRENCH, Material.CARROT_ON_A_STICK);
    }

    @Override
    public List<CustomItem> registerItems() {
        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
        ItemStack item = new ItemStack(Material.CARROT_ON_A_STICK);
        ItemMeta meta = item.getItemMeta();
        meta.setUnbreakable(true);
        meta.setCustomModelData(Integer.valueOf(4321));
        item.setDurability((short)1);
        meta.displayName(MiniMessage.miniMessage().deserialize((Object)TranslationManager.getString(Config.getLanguage(), "rotation_wrench.item_name")));
        item.setItemMeta(meta);
        CustomItem wrench = new CustomItem("rotation_wrench", item);
        items.add(wrench);
        return items;
    }

    @Override
    public void init() {
        super.init();
        NamespacedKey key = Key.get("rotation_wrench");
        ShapedRecipe recipe = new ShapedRecipe(key, TItem.ROTATION_WRENCH.getItem());
        recipe.shape(new String[]{" # ", " ##", "$  "});
        recipe.setIngredient('#', Material.GOLD_INGOT);
        recipe.setIngredient('$', Material.IRON_INGOT);
        this.addRecipe((Recipe)recipe);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.getConfig().getBoolean("suggest-pack")) {
            event.getPlayer().addResourcePack(UUID.nameUUIDFromBytes(this.hash), "https://drive.google.com/uc?export=download&id=1poeTqOmlGj0e40s1FSlop0lhuUNTxrVZ", this.hash, "Would You like to install the Rotation Wrench resource pack?", false);
        }
    }

    @EventHandler
    public void onUse(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (item.getItemMeta() == null) {
            return;
        }
        if (item.getItemMeta().getDisplayName() == null) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equalsIgnoreCase(this.getText("item_name", new ComponentLike[0]).toString())) {
            return;
        }
        if (item.getType() != Material.CARROT_ON_A_STICK) {
            return;
        }
        if (!item.getItemMeta().isUnbreakable()) {
            return;
        }
        if (event.getPlayer().getVehicle() != null) {
            event.setCancelled(true);
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!RotationWrench.isRedstone(event.getClickedBlock().getType()) && !RotationWrench.isTerracotta(event.getClickedBlock().getType())) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        if (RotationWrench.isRedstone(block.getType()) && this.getConfig().getBoolean("rotate-redstone")) {
            if (!Permission.ROTATION_WRENCH_REDSTONE.check((CommandSender)event.getPlayer())) {
                return;
            }
            Directional data = (Directional)block.getBlockData();
            if (data instanceof Piston && ((Piston)data).isExtended()) {
                return;
            }
            int facing = this.faces.indexOf(data.getFacing());
            BlockFace nextFace = null;
            int i = 0;
            while (nextFace == null || !data.getFaces().contains(nextFace)) {
                if (i >= 6) {
                    throw new IllegalStateException("Infinite");
                }
                nextFace = event.getPlayer().isSneaking() ? (facing - 1 < 0 ? this.faces.get(facing + 6 - 1) : this.faces.get(facing - 1)) : this.faces.get((facing + 1) % 6);
                facing = this.faces.indexOf(nextFace);
                ++i;
            }
            event.setCancelled(true);
            data.setFacing(nextFace);
            block.setBlockData((BlockData)data);
            event.getPlayer().playSound(block.getLocation(), Sound.BLOCK_COPPER_DOOR_OPEN, 1.0f, 0.7f);
            return;
        }
        if (RotationWrench.isTerracotta(block.getType()) && this.getConfig().getBoolean("rotate-terracotta")) {
            if (!Permission.ROTATION_WRENCH_TERRACOTTA.check((CommandSender)event.getPlayer())) {
                return;
            }
            Directional data = (Directional)block.getBlockData();
            int facing = this.faces.indexOf(data.getFacing());
            BlockFace nextFace = null;
            int i = 0;
            while (nextFace == null || !data.getFaces().contains(nextFace)) {
                if (i >= 6) {
                    throw new IllegalStateException("Infinite");
                }
                nextFace = event.getPlayer().isSneaking() ? (facing - 1 < 0 ? this.faces.get(facing + 6 - 1) : this.faces.get(facing - 1)) : this.faces.get((facing + 1) % 6);
                facing = this.faces.indexOf(nextFace);
                ++i;
            }
            event.setCancelled(true);
            data.setFacing(nextFace);
            block.setBlockData((BlockData)data);
            event.getPlayer().playSound(block.getLocation(), Sound.BLOCK_COPPER_DOOR_OPEN, 1.0f, 0.7f);
        }
    }

    private static boolean isRedstone(Material material) {
        boolean rtn = false;
        switch (material) {
            case PISTON: 
            case STICKY_PISTON: 
            case DROPPER: 
            case HOPPER: 
            case DISPENSER: 
            case COMPARATOR: 
            case REPEATER: 
            case OBSERVER: {
                rtn = true;
            }
        }
        return rtn;
    }

    private static boolean isTerracotta(Material material) {
        return material.toString().toUpperCase().contains("TERRACOTTA");
    }
}

