/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.sawmill.recipes;

import java.util.ArrayList;
import java.util.List;
import me.teakivy.teakstweaks.packs.sawmill.BaseSawmillRecipe;
import me.teakivy.teakstweaks.utils.config.Config;
import org.bukkit.Material;
import org.bukkit.inventory.Recipe;

public class BambooSawmill
extends BaseSawmillRecipe {
    protected final Material block = Material.BAMBOO_BLOCK;
    protected final Material strippedBlock = Material.STRIPPED_BAMBOO_BLOCK;
    protected final Material planks = Material.BAMBOO_PLANKS;
    protected final Material mosaic = Material.BAMBOO_MOSAIC;
    protected final Material stairs = Material.BAMBOO_STAIRS;
    protected final Material mosaicStairs = Material.BAMBOO_MOSAIC_STAIRS;
    protected final Material slabs = Material.BAMBOO_SLAB;
    protected final Material mosaicSlabs = Material.BAMBOO_MOSAIC_SLAB;
    protected final Material fence = Material.BAMBOO_FENCE;
    protected final Material fenceGate = Material.BAMBOO_FENCE_GATE;
    protected final Material door = Material.BAMBOO_DOOR;
    protected final Material trapdoor = Material.BAMBOO_TRAPDOOR;
    protected final Material pressurePlate = Material.BAMBOO_PRESSURE_PLATE;
    protected final Material button = Material.BAMBOO_BUTTON;
    protected final Material sign = Material.BAMBOO_SIGN;

    @Override
    public List<Recipe> getAllRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        recipes.addAll(this.getBlockRelatedRecipes(this.block));
        recipes.addAll(this.getBlockRelatedRecipes(this.strippedBlock));
        recipes.addAll(this.getPlankRelatedRecipes(this.planks));
        recipes.addAll(this.getPlankRelatedRecipes(this.mosaic));
        return recipes;
    }

    public List<Recipe> getBlockRelatedRecipes(Material material) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.block != material) {
            recipes.add(this.getRecipe(material, this.block, 1));
        }
        if (this.strippedBlock != material) {
            recipes.add(this.getRecipe(material, this.strippedBlock, 1));
        }
        recipes.add(this.getRecipe(material, this.planks, 4));
        recipes.add(this.getRecipe(material, this.mosaic, 4));
        recipes.add(this.getRecipe(material, this.stairs, 5));
        recipes.add(this.getRecipe(material, this.mosaicStairs, 5));
        recipes.add(this.getRecipe(material, this.slabs, 8));
        recipes.add(this.getRecipe(material, this.mosaicSlabs, 8));
        recipes.add(this.getRecipe(material, this.fence, 2));
        recipes.add(this.getRecipe(material, this.fenceGate, 2));
        recipes.add(this.getRecipe(material, this.door, 2));
        int trapdoorAmount = 2;
        if (Config.isCraftingTweakEnabled("more-trapdoors")) {
            trapdoorAmount = 8;
        }
        recipes.add(this.getRecipe(material, this.trapdoor, trapdoorAmount));
        recipes.add(this.getRecipe(material, this.pressurePlate, 4));
        recipes.add(this.getRecipe(material, this.button, 4));
        recipes.add(this.getRecipe(material, this.sign, 2));
        return recipes;
    }

    public List<Recipe> getPlankRelatedRecipes(Material material) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (material != this.planks) {
            recipes.add(this.getRecipe(material, this.planks, 1));
        }
        if (material != this.mosaic) {
            recipes.add(this.getRecipe(material, this.mosaic, 1));
        }
        recipes.add(this.getRecipe(material, this.stairs, 1));
        recipes.add(this.getRecipe(material, this.mosaicStairs, 1));
        recipes.add(this.getRecipe(material, this.slabs, 2));
        recipes.add(this.getRecipe(material, this.mosaicSlabs, 2));
        int trapdoorAmount = 3;
        if (Config.isCraftingTweakEnabled("more-trapdoors")) {
            recipes.add(this.getRecipe(material, this.trapdoor, trapdoorAmount));
        }
        recipes.add(this.getRecipe(material, this.pressurePlate, 1));
        recipes.add(this.getRecipe(material, this.button, 1));
        return recipes;
    }
}

