/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.silencemobs;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SilenceMobs
extends BasePack {
    ArrayList<EntityType> minecartTypes = new ArrayList();

    public SilenceMobs() {
        super(TTPack.SILENCE_MOBS, Material.SCULK_SHRIEKER);
        if (this.minecartTypes.isEmpty()) {
            this.minecartTypes.add(EntityType.MINECART);
            this.minecartTypes.add(EntityType.FURNACE_MINECART);
            this.minecartTypes.add(EntityType.CHEST_MINECART);
            this.minecartTypes.add(EntityType.COMMAND_BLOCK_MINECART);
            this.minecartTypes.add(EntityType.TNT_MINECART);
            this.minecartTypes.add(EntityType.HOPPER_MINECART);
            this.minecartTypes.add(EntityType.SPAWNER_MINECART);
        }
    }

    @EventHandler
    public void onSilence(PlayerInteractAtEntityEvent event) {
        if (!Permission.SILENCE_MOBS.check((CommandSender)event.getPlayer())) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (this.minecartTypes.contains(entity.getType())) {
            if (!this.getConfig().getBoolean("allow-minecarts")) {
                return;
            }
            ItemStack nametag = event.getPlayer().getInventory().getItem(event.getHand());
            if (nametag.getType() != Material.NAME_TAG) {
                return;
            }
            if (!nametag.hasItemMeta()) {
                return;
            }
            if (!Objects.requireNonNull(nametag.getItemMeta()).getDisplayName().replaceAll("_", " ").replaceAll("-", " ").trim().equalsIgnoreCase(this.getString("activation_name"))) {
                return;
            }
            entity.setSilent(true);
            entity.customName(this.getText("silenced_name", new ComponentLike[0]));
            event.setCancelled(true);
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                event.getPlayer().getInventory().getItem(event.getHand()).setAmount(nametag.getAmount() - 1);
            }
            return;
        }
        try {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TeaksTweaks.getInstance(), () -> {
                Entity entity1 = this.getEntityByUniqueId(entity.getUniqueId());
                if (entity1 == null) {
                    return;
                }
                if (entity1.customName() == null) {
                    return;
                }
                if (entity1.getCustomName().replaceAll("_", " ").replaceAll("-", " ").trim().equalsIgnoreCase(this.getString("activation_name"))) {
                    entity.setSilent(true);
                    entity.customName(this.getText("silenced_name", new ComponentLike[0]));
                }
            }, 10L);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @EventHandler
    public void onUnSilence(PlayerInteractAtEntityEvent event) {
        if (!Permission.SILENCE_MOBS.check((CommandSender)event.getPlayer())) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (this.minecartTypes.contains(entity.getType())) {
            if (!this.getConfig().getBoolean("allow-minecarts")) {
                return;
            }
            ItemStack nametag = event.getPlayer().getInventory().getItem(event.getHand());
            if (nametag.getType() != Material.NAME_TAG) {
                return;
            }
            if (!nametag.hasItemMeta()) {
                return;
            }
            if (!Objects.requireNonNull(nametag.getItemMeta()).getDisplayName().replaceAll("_", " ").replaceAll("-", " ").trim().equalsIgnoreCase(this.getString("deactivation_name"))) {
                return;
            }
            entity.setSilent(false);
            entity.customName(null);
            event.setCancelled(true);
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                event.getPlayer().getInventory().getItem(event.getHand()).setAmount(nametag.getAmount() - 1);
            }
            return;
        }
        try {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TeaksTweaks.getInstance(), () -> {
                Entity entity1 = this.getEntityByUniqueId(entity.getUniqueId());
                if (entity1 == null) {
                    return;
                }
                if (entity1.customName() == null) {
                    return;
                }
                if (entity1.getCustomName().replaceAll("_", " ").replaceAll("-", " ").trim().equalsIgnoreCase(this.getString("deactivation_name"))) {
                    entity.setSilent(false);
                    entity.customName(null);
                }
            }, 10L);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public Entity getEntityByUniqueId(UUID uniqueId) {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uniqueId)) continue;
                return entity;
            }
        }
        return null;
    }
}

