/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.spawningspheres;

import java.util.LinkedHashMap;
import me.teakivy.teakstweaks.packs.spawningspheres.SphereType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpawningSphere {
    private static final int INNER_RADIUS = 24;
    private static final int OUTER_RADIUS = 128;
    private boolean inUse;
    private Location center;
    protected SphereType type;

    public SpawningSphere(LinkedHashMap<String, Object> map, SphereType type) {
        this.type = type;
        this.deserialize(map);
    }

    public void createSphere() {
        if (this.inUse) {
            return;
        }
        this.createSphere(SphereIO.INNER);
        this.createSphere(SphereIO.OUTER);
        this.summonStand(this.center, SphereIO.INNER, true);
        this.inUse = true;
    }

    public void setCenter(Location location) {
        location.setYaw(0.0f);
        location.setPitch(0.0f);
        this.center = location;
    }

    public Location getCenter() {
        return this.center;
    }

    private void createSphere(SphereIO sphereIO) {
        int radius = sphereIO == SphereIO.INNER ? 24 : 128;
        for (double i = 0.0; i <= Math.PI; i += 0.3141592653589793) {
            double curRadius = Math.sin(i);
            double y = Math.cos(i) * (double)radius;
            for (double a = 0.0; a < Math.PI * 2; a += 0.3141592653589793) {
                double x = Math.cos(a) * curRadius * (double)radius;
                double z = Math.sin(a) * curRadius * (double)radius;
                Location loc = this.center.clone().add(x, y, z);
                this.summonStand(loc, sphereIO);
            }
        }
    }

    private void summonStand(Location location, SphereIO sphereIO) {
        this.summonStand(location, sphereIO, false);
    }

    private void summonStand(Location location, SphereIO sphereIO, boolean isCenter) {
        ArmorStand stand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        stand.setGravity(false);
        stand.setVisible(false);
        stand.setSmall(true);
        stand.setMarker(true);
        stand.addScoreboardTag(this.type.getColorName() + "_sphere");
        stand.addScoreboardTag("spawning_sphere");
        stand.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 999999, 0));
        if (isCenter) {
            stand.customName((Component)Component.translatable((String)"spawning_spheres.center_stand"));
            stand.setCustomNameVisible(true);
        }
        stand.getEquipment().setHelmet(new ItemStack(sphereIO.getMaterial(this.type)));
        this.type.getTeam().addEntry(stand.getUniqueId().toString());
    }

    public void removeSphere() {
        for (Entity entity : this.center.getWorld().getEntities()) {
            if (!entity.getScoreboardTags().contains(this.type.getColorName() + "_sphere")) continue;
            entity.remove();
        }
        this.inUse = false;
    }

    public void teleport(Player player) {
        player.teleportAsync(this.center);
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public LinkedHashMap<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.type.getColorName() + ".in_use", this.inUse);
        if (!this.inUse) {
            return map;
        }
        map.put(this.type.getColorName() + ".center.x", this.center.getX());
        map.put(this.type.getColorName() + ".center.y", this.center.getY());
        map.put(this.type.getColorName() + ".center.z", this.center.getZ());
        map.put(this.type.getColorName() + ".center.world", this.center.getWorld().getName());
        return map;
    }

    public void deserialize(LinkedHashMap<String, Object> map) {
        Boolean inUse = (Boolean)map.get(this.type.getColorName() + ".in_use");
        boolean bl = this.inUse = inUse != null && inUse != false;
        if (!this.inUse) {
            return;
        }
        double x = (Double)map.get(this.type.getColorName() + ".center.x");
        double y = (Double)map.get(this.type.getColorName() + ".center.y");
        double z = (Double)map.get(this.type.getColorName() + ".center.z");
        String world = (String)map.get(this.type.getColorName() + ".center.world");
        this.center = new Location(Bukkit.getWorld((String)world), x, y, z);
    }

    public static enum SphereIO {
        INNER,
        OUTER;


        public Material getMaterial(SphereType type) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> type.getMaterial();
                case 1 -> type.getSubMaterial();
            };
        }
    }
}

