/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.spawningspheres;

import java.util.LinkedHashMap;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.spawningspheres.SpawningSphere;
import me.teakivy.teakstweaks.packs.spawningspheres.SphereType;
import me.teakivy.teakstweaks.utils.JsonManager;
import me.teakivy.teakstweaks.utils.register.TTPack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawningSpheres
extends BasePack {
    private static SpawningSphere redSphere;
    private static SpawningSphere blueSphere;
    private static SpawningSphere greenSphere;

    public SpawningSpheres() {
        super(TTPack.SPAWNING_SPHERES, Material.WARDEN_SPAWN_EGG);
    }

    @Override
    public void init() {
        super.init();
        LinkedHashMap<String, Object> json = SpawningSpheres.getJson();
        redSphere = new SpawningSphere(json, SphereType.RED);
        blueSphere = new SpawningSphere(json, SphereType.BLUE);
        greenSphere = new SpawningSphere(json, SphereType.GREEN);
    }

    public static void save() {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.putAll(redSphere.serialize());
        json.putAll(blueSphere.serialize());
        json.putAll(greenSphere.serialize());
        JsonManager.saveToFile(json, "data/spawning_spheres.json");
    }

    public static boolean teleport(SphereType type, Player player) {
        SpawningSphere sphere = SpawningSpheres.getSphere(type);
        if (sphere == null) {
            return false;
        }
        if (!sphere.isInUse()) {
            return false;
        }
        sphere.teleport(player);
        return true;
    }

    public static boolean summonSphere(SphereType type, Location location) {
        SpawningSphere sphere = SpawningSpheres.getSphere(type);
        if (sphere == null) {
            return false;
        }
        if (sphere.isInUse()) {
            return false;
        }
        sphere.setCenter(location);
        sphere.createSphere();
        SpawningSpheres.save();
        return true;
    }

    public static boolean removeSphere(SphereType type, Player executor) {
        SpawningSphere sphere = SpawningSpheres.getSphere(type);
        if (sphere == null) {
            return false;
        }
        if (!sphere.isInUse()) {
            return false;
        }
        Location location = executor.getLocation();
        executor.teleportAsync(sphere.getCenter());
        Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), sphere::removeSphere, 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)TeaksTweaks.getInstance(), () -> {
            executor.teleportAsync(location);
            SpawningSpheres.save();
        }, 60L);
        return true;
    }

    public static SpawningSphere getSphere(SphereType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SphereType.RED -> redSphere;
            case SphereType.BLUE -> blueSphere;
            case SphereType.GREEN -> greenSphere;
        };
    }

    private static LinkedHashMap<String, Object> getJson() {
        return JsonManager.get("data/spawning_spheres.json");
    }
}

