/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.stairchairs;

import java.util.Objects;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class StairChairs
extends BasePack {
    public StairChairs() {
        super(TTPack.STAIR_CHAIRS, Material.SMOOTH_QUARTZ_STAIRS);
    }

    @EventHandler
    public void onChairMaker(PlayerInteractEvent event) {
        if (!Permission.STAIR_CHAIRS_CREATE.check((CommandSender)event.getPlayer())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.SADDLE) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getClickedBlock().getType().toString().contains("STAIR")) {
            return;
        }
        if (this.isChair(event.getClickedBlock().getLocation())) {
            return;
        }
        if (((Stairs)event.getClickedBlock().getBlockData()).getHalf() != Bisected.Half.BOTTOM) {
            return;
        }
        Location loc = event.getClickedBlock().getLocation();
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            event.getPlayer().getInventory().getItemInMainHand().setAmount(event.getPlayer().getInventory().getItemInMainHand().getAmount() - 1);
        }
        Marker marker = (Marker)Objects.requireNonNull(loc.getWorld()).spawnEntity(loc, EntityType.MARKER);
        marker.addScoreboardTag("chair");
        event.getPlayer().sendMessage(this.getText("chair_created", new ComponentLike[0]));
    }

    public boolean isChair(Location loc) {
        for (Object o : loc.getBlock().getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0).stream().toArray()) {
            if (!(o instanceof Marker)) continue;
            return ((Marker)o).getScoreboardTags().contains("chair");
        }
        return false;
    }

    @EventHandler
    public void onChairDestroy(BlockBreakEvent event) {
        if (!this.isChair(event.getBlock().getLocation())) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        for (Object o : loc.getBlock().getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0).stream().toArray()) {
            if (!(o instanceof Marker)) continue;
            ((Marker)o).remove();
        }
        event.getBlock().getWorld().dropItem(loc.add(0.5, 0.5, 0.5), new ItemStack(Material.SADDLE));
        event.getPlayer().sendMessage(this.getText("chair_destroyed", new ComponentLike[0]));
    }

    @EventHandler
    public void onSit(PlayerInteractEvent event) {
        if (!Permission.STAIR_CHAIRS_SIT.check((CommandSender)event.getPlayer())) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (!this.isChair(block.getLocation())) {
            return;
        }
        if (!block.getType().name().toLowerCase().contains("stairs")) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (block.getLocation().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) {
            return;
        }
        ItemDisplay seat = (ItemDisplay)block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.5, 0.5), EntityType.ITEM_DISPLAY);
        seat.setRotation(0.0f, 90.0f);
        seat.addScoreboardTag("chair-rider");
        seat.setInvulnerable(true);
        seat.addPassenger((Entity)event.getPlayer());
    }

    @EventHandler
    public void onDismount(EntityDismountEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDismounted() instanceof ItemDisplay)) {
            return;
        }
        if (event.getDismounted().getScoreboardTags().contains("chair-rider")) {
            event.getDismounted().remove();
        }
        event.getEntity().teleportAsync(event.getEntity().getLocation().add(0.0, 1.1, 0.0));
    }
}

