/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.thundershrine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ThunderShrine
extends BasePack {
    private int particleTask = -1;

    public ThunderShrine() {
        super(TTPack.THUNDER_SHRINE, Material.NETHER_STAR);
    }

    @Override
    public void init() {
        super.init();
        this.register();
    }

    public void register() {
        if (!this.getConfig().getBoolean("idle-particles")) {
            this.particleTask = -1;
        }
        this.particleTask = new BukkitRunnable(this){

            public void run() {
                ThunderShrine.runParticles();
            }
        }.runTaskTimer((Plugin)TeaksTweaks.getInstance(), 0L, 3L).getTaskId();
    }

    public static void runParticles() {
        for (Entity shrine : ThunderShrine.getShrines()) {
            shrine.getWorld().spawnParticle(Particle.ENCHANT, shrine.getLocation().add(0.0, 1.0, 0.0), 1, 0.1, 0.1, 0.1, 1.0);
        }
    }

    @EventHandler
    public void onDrop(final PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (!Permission.THUNDER_SHRINE_USE.check((CommandSender)event.getPlayer())) {
            return;
        }
        if (item.getType() != Material.getMaterial((String)this.getConfig().getString("summoning.summoning-item"))) {
            return;
        }
        new BukkitRunnable(this){

            public void run() {
                if (ThunderShrine.isNearShrine(event.getItemDrop().getLocation())) {
                    event.getItemDrop().remove();
                    ThunderShrine.startThunder(event.getPlayer(), event.getItemDrop().getLocation());
                }
                if (event.getItemDrop().isDead() || event.getItemDrop().getItemStack().getAmount() != 1) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)TeaksTweaks.getInstance(), 0L, 20L);
    }

    public static void startThunder(Player player, Location loc) {
        ConfigurationSection config = Config.get().getConfigurationSection("packs.thunder-shrine");
        World world = player.getWorld();
        if (config.getBoolean("summoning.strike-lightning")) {
            world.strikeLightning(loc.add(0.0, 1.0, 0.0));
        }
        if (config.getBoolean("summoning.show-particles")) {
            world.spawnParticle(Particle.FLAME, loc, 100, 0.0, 0.0, 0.0, 0.5);
        }
        world.setWeatherDuration(6000);
        world.setThunderDuration(6000);
        world.setStorm(true);
        world.setThundering(true);
        if (!config.getBoolean("summoning.broadcast-message")) {
            return;
        }
        for (Player oPlayer : Bukkit.getOnlinePlayers()) {
            oPlayer.sendMessage((Component)Component.translatable((String)"thunder_shrine.storm_initialize"));
        }
    }

    public static List<Entity> getShrines() {
        ArrayList<Entity> shrines = new ArrayList<Entity>();
        Bukkit.getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
            if (ThunderShrine.isShrine(entity)) {
                shrines.add((Entity)entity);
            }
        }));
        return shrines;
    }

    public static boolean isShrine(Entity entity) {
        if (!(entity instanceof Marker)) {
            return false;
        }
        return entity.getPersistentDataContainer().has(Key.get("thunder-shrine"), PersistentDataType.BOOLEAN);
    }

    public static boolean isNearShrine(Location loc) {
        for (Entity entity : Objects.requireNonNull(loc.getWorld()).getEntities()) {
            if (!ThunderShrine.isShrine(entity) || !(entity.getLocation().distance(loc) < 1.0)) continue;
            return true;
        }
        return false;
    }

    public static void createShrine(Location loc) throws IOException {
        Marker shrine = (Marker)Objects.requireNonNull(loc.getWorld()).spawnEntity(loc.add(0.5, 0.0, 0.5), EntityType.MARKER);
        PersistentDataContainer container = shrine.getPersistentDataContainer();
        container.set(Key.get("thunder-shrine"), PersistentDataType.BOOLEAN, (Object)true);
    }

    @Override
    public void unregister() {
        super.unregister();
        if (this.particleTask != -1) {
            Bukkit.getScheduler().cancelTask(this.particleTask);
        }
    }
}

