/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.tpa;

import me.teakivy.teakstweaks.packs.back.Back;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.entity.Player;

public class TPARequest {
    private final Player sender;
    private final Player target;
    private final long time;
    private final TPAType type;
    private boolean accepted = false;

    public TPARequest(Player sender, Player target, TPAType type) {
        this.sender = sender;
        this.target = target;
        this.time = System.currentTimeMillis();
        this.type = type;
    }

    public Player getFrom() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.sender;
            case 1 -> this.target;
        };
    }

    public Player getTo() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.target;
            case 1 -> this.sender;
        };
    }

    public Player getSender() {
        return this.sender;
    }

    public Player getTarget() {
        return this.target;
    }

    public TPAType getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.time > 60000L;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void accept() {
        this.accepted = true;
        Back.backLoc.put(this.getFrom().getUniqueId(), this.getTo().getLocation());
        this.getFrom().teleportAsync(this.getTo().getLocation());
        this.getTo().sendMessage((Component)Component.translatable((String)"tpa.teleporting_to_you", (ComponentLike[])new ComponentLike[]{Argument.string((String)"player", (String)this.getFrom().getName())}));
        this.getFrom().sendMessage((Component)Component.translatable((String)"tpa.teleporting", (ComponentLike[])new ComponentLike[]{Argument.string((String)"player", (String)this.getTo().getName())}));
    }

    public static enum TPAType {
        TPA("tpa"),
        TPAHERE("tpahere");

        private final String key;

        private TPAType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

