/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.villagerdeathmessages;

import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;

public class VillagerDeathMessages
extends BasePack {
    public VillagerDeathMessages() {
        super(TTPack.VILLAGER_DEATH_MESSAGES, Material.TORCH);
    }

    @EventHandler
    public void onMobDeath(EntityDeathEvent event) {
        if (event.getEntity().getType() == EntityType.VILLAGER) {
            Location loc = event.getEntity().getLocation();
            Component deathMessage = this.getText("death_message", VillagerDeathMessages.insert("x", loc.getBlockX()), VillagerDeathMessages.insert("y", loc.getBlockY()), VillagerDeathMessages.insert("z", loc.getBlockZ()), this.insert("world", this.getWorldName(loc)));
            if (this.getConfig().getBoolean("show-in-chat")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.sendMessage(deathMessage);
                }
                return;
            }
            Logger.info(deathMessage);
        }
    }

    private Component getWorldName(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return VillagerDeathMessages.newText("<yellow>Unknown World", new TagResolver[0]);
        }
        return switch (world.getName()) {
            case "world" -> VillagerDeathMessages.newText("<yellow>The Overworld", new TagResolver[0]);
            case "world_nether" -> VillagerDeathMessages.newText("<red>The Nether", new TagResolver[0]);
            case "world_the_end" -> VillagerDeathMessages.newText("<light_purple>The End", new TagResolver[0]);
            default -> VillagerDeathMessages.newText("<yellow>" + world.getName(), new TagResolver[0]);
        };
    }
}

