/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.wanderingtrades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.packs.wanderingtrades.MiniBlocks;
import me.teakivy.teakstweaks.utils.UUIDUtils;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;

public class WanderingTrades
extends BasePack {
    private final HashSet<String> playerNames = new HashSet(this.getConfig().getStringList("player-heads.players"));

    public WanderingTrades() {
        super(TTPack.WANDERING_TRADES, Material.LEAD);
    }

    @EventHandler
    public void traderSpawn(EntitySpawnEvent event) {
        if (event.getEntityType() == EntityType.WANDERING_TRADER) {
            Location location = event.getLocation().clone();
            if (Config.isPackEnabled("wandering-trader-announcements")) {
                this.runAnnouncement(location);
            }
            if (location.getWorld() == null) {
                return;
            }
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            if (this.getConfig().getBoolean("player-heads.has-player-heads")) {
                this.getHeadTrades().thenAccept(recipes1 -> Bukkit.getScheduler().runTask((Plugin)TeaksTweaks.getInstance(), () -> {
                    WanderingTrader trader = (WanderingTrader)event.getEntity();
                    recipes.addAll((Collection<MerchantRecipe>)recipes1);
                    recipes.addAll(MiniBlocks.getBlockTrades());
                    recipes.addAll(trader.getRecipes());
                    trader.setRecipes(recipes);
                }));
                return;
            }
            WanderingTrader trader = (WanderingTrader)event.getEntity();
            recipes.addAll(MiniBlocks.getBlockTrades());
            recipes.addAll(trader.getRecipes());
            trader.setRecipes(recipes);
        }
    }

    private void runAnnouncement(Location location) {
        ConfigurationSection config = Config.getPackConfig("wandering-trader-announcements");
        int radius = config.getInt("radius");
        if (radius < 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage((Component)Component.translatable((String)"wandering_trader_announcements.announcement_all"));
            }
            return;
        }
        location.getWorld().getNearbyEntities(location, (double)radius, (double)radius, (double)radius).forEach(entity -> {
            if (entity.getType() == EntityType.PLAYER) {
                entity.sendMessage((Component)Component.translatable((String)"wandering_trader_announcements.announcement"));
            }
        });
    }

    private CompletableFuture<List<MerchantRecipe>> getHeadTrades() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            if (this.getConfig().getBoolean("player-heads.read-from-whitelist")) {
                this.playerNames.clear();
                for (OfflinePlayer pl : Bukkit.getWhitelistedPlayers()) {
                    this.playerNames.add(pl.getName());
                }
            }
            return this.playerNames;
        }).thenCompose(playerNames -> {
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            HashSet<String> headNames = new HashSet<String>();
            Random rand = new Random();
            if (Config.isDevMode()) {
                for (String player : playerNames) {
                    futures.add(this.newHeadRecipe(player).exceptionally(ex -> null));
                }
            } else {
                int amount = this.getConfig().getInt("player-heads.amount-of-trades");
                int attempts = amount + 25;
                ArrayList playerList = new ArrayList(playerNames);
                while (amount > 0 && attempts > 0) {
                    --attempts;
                    String name = (String)playerList.get(rand.nextInt(playerList.size()));
                    if (headNames.contains(name)) continue;
                    headNames.add(name);
                    --amount;
                    futures.add(this.newHeadRecipe(name).exceptionally(ex -> null));
                }
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).completeOnTimeout(null, 30L, TimeUnit.SECONDS).thenApply(v -> {
                ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
                for (CompletableFuture future : futures) {
                    try {
                        MerchantRecipe recipe = (MerchantRecipe)future.join();
                        if (recipe == null) continue;
                        trades.add(recipe);
                    }
                    catch (Exception exception) {}
                }
                return trades;
            });
        })).exceptionally(ex -> new ArrayList());
    }

    private CompletableFuture<MerchantRecipe> newHeadRecipe(String playerName) {
        return ((CompletableFuture)UUIDUtils.getPlayerHead(playerName).thenApply(playerHead -> {
            try {
                MerchantRecipe recipe = new MerchantRecipe(playerHead, this.getConfig().getInt("player-heads.per-trade"));
                recipe.addIngredient(new ItemStack(Material.EMERALD, 1));
                return recipe;
            }
            catch (Exception e) {
                return null;
            }
        })).completeOnTimeout(null, 10L, TimeUnit.SECONDS);
    }
}

