/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.packs.xpmanagement;

import java.util.ArrayList;
import me.teakivy.teakstweaks.packs.BasePack;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.XPUtils;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Furnace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class XPManagement
extends BasePack {
    public XPManagement() {
        super(TTPack.XP_MANAGEMENT, Material.EXPERIENCE_BOTTLE);
    }

    @Override
    public void init() {
        super.init();
        this.registerRecipe();
    }

    public void registerRecipe() {
        if (!this.getConfig().getBoolean("allow-smelting")) {
            return;
        }
        FurnaceRecipe recipe = new FurnaceRecipe(Key.get("smeltable_xp_bottle"), new ItemStack(Material.GLASS_BOTTLE), Material.EXPERIENCE_BOTTLE, (float)this.getConfig().getInt("take-xp-amount"), 100);
        this.addRecipe((Recipe)recipe);
    }

    @EventHandler
    public void onSmelt(FurnaceSmeltEvent event) {
        PersistentDataContainer data;
        if (event.getSource().getType() != Material.EXPERIENCE_BOTTLE) {
            return;
        }
        if (event.getSource().hasItemMeta() && (data = event.getSource().getItemMeta().getPersistentDataContainer()).has(Key.get("xp_amount"), PersistentDataType.INTEGER)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBurn(FurnaceBurnEvent event) {
        PersistentDataContainer data;
        Furnace furnace = (Furnace)event.getBlock().getState();
        if (furnace.getInventory().getSmelting() == null) {
            return;
        }
        if (furnace.getInventory().getSmelting().getType() != Material.EXPERIENCE_BOTTLE) {
            return;
        }
        if (furnace.getInventory().getSmelting().hasItemMeta() && (data = furnace.getInventory().getSmelting().getItemMeta().getPersistentDataContainer()).has(Key.get("xp_amount"), PersistentDataType.INTEGER)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void bottleXP(PlayerInteractEvent event) {
        int takeXPAmount;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!Permission.XP_MANAGEMENT_BOTTLE.check((CommandSender)player)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.ENCHANTING_TABLE) {
            return;
        }
        if (item == null) {
            return;
        }
        if (item.getType() != Material.GLASS_BOTTLE) {
            return;
        }
        if (XPUtils.getPlayerExp(player) <= this.getConfig().getInt("take-xp-amount")) {
            return;
        }
        int finalXPAmount = takeXPAmount = this.getConfig().getInt("take-xp-amount");
        int timesToBottle = 1;
        if (player.isSneaking() && this.getConfig().getBoolean("sneak-to-bottle-all")) {
            if (XPUtils.getPlayerExp(player) >= item.getAmount() * takeXPAmount) {
                timesToBottle = item.getAmount();
                finalXPAmount = item.getAmount() * takeXPAmount;
            } else {
                int bottles = item.getAmount();
                int xpTimes = (int)Math.floor((double)XPUtils.getPlayerExp(player) / (double)takeXPAmount);
                if (xpTimes > bottles) {
                    timesToBottle = item.getAmount();
                    finalXPAmount = takeXPAmount * item.getAmount();
                }
                if (bottles > xpTimes) {
                    timesToBottle = xpTimes;
                    finalXPAmount = xpTimes * takeXPAmount;
                }
            }
        }
        event.setCancelled(true);
        int itemAmount = item.getAmount();
        int newAmount = itemAmount - timesToBottle;
        if (newAmount < 0) {
            newAmount = 0;
        }
        if (newAmount > 64) {
            newAmount = 64;
        }
        item.setAmount(newAmount);
        player.giveExp(-finalXPAmount);
        ItemStack xpBottle = new ItemStack(Material.EXPERIENCE_BOTTLE, 1);
        ItemMeta xpMeta = xpBottle.getItemMeta();
        if (this.getConfig().getBoolean("display-amount")) {
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(this.getText("bottle_contains", XPManagement.insert("return_amount", this.getConfig().getInt("return-xp-amount"))));
            xpMeta.lore(lore);
        }
        PersistentDataContainer data = xpMeta.getPersistentDataContainer();
        data.set(Key.get("xp_amount"), PersistentDataType.INTEGER, (Object)this.getConfig().getInt("return-xp-amount"));
        data.set(Key.get("xp_smelt_amount"), PersistentDataType.INTEGER, (Object)this.getConfig().getInt("take-xp-amount"));
        xpBottle.setItemMeta(xpMeta);
        if (this.getConfig().getBoolean("sneak-to-bottle-all") && player.isSneaking()) {
            for (int i = 0; i < timesToBottle; ++i) {
                player.getInventory().addItem(new ItemStack[]{xpBottle});
            }
        } else {
            player.getInventory().addItem(new ItemStack[]{xpBottle});
        }
    }

    @EventHandler
    public void onThrow(ExpBottleEvent event) {
        PersistentDataContainer data;
        ThrownExpBottle bottle = event.getEntity();
        if (bottle.getItem().getItemMeta() != null && (data = bottle.getItem().getItemMeta().getPersistentDataContainer()).has(Key.get("xp_amount"), PersistentDataType.INTEGER)) {
            event.setExperience(((Integer)data.get(Key.get("xp_amount"), PersistentDataType.INTEGER)).intValue());
        }
    }
}

