/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemUtils {
    public static ItemStack handleUse(ItemStack item) {
        return ItemUtils.handleUse(item, null);
    }

    public static ItemStack handleUse(ItemStack item, Player player) {
        if (item == null) {
            return null;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return item;
        }
        if (item.getType().getMaxDurability() > 0) {
            return item.damage(1, (LivingEntity)player);
        }
        item.setAmount(item.getAmount() - 1);
        return item.getAmount() > 0 ? item : null;
    }

    public static List<Material> getAllDamageable() {
        ArrayList<Material> damageable = new ArrayList<Material>();
        damageable.addAll(ItemUtils.getAllTools());
        damageable.addAll(ItemUtils.getAllWeapons());
        damageable.addAll(ItemUtils.getAllArmor());
        return damageable;
    }

    public static List<Material> getAllTools() {
        ArrayList<Material> tools = new ArrayList<Material>();
        tools.addAll(Tag.ITEMS_PICKAXES.getValues());
        tools.addAll(Tag.ITEMS_AXES.getValues());
        tools.addAll(Tag.ITEMS_SHOVELS.getValues());
        tools.addAll(Tag.ITEMS_HOES.getValues());
        tools.add(Material.SHEARS);
        tools.add(Material.BRUSH);
        tools.add(Material.FLINT_AND_STEEL);
        tools.add(Material.FISHING_ROD);
        tools.add(Material.CARROT_ON_A_STICK);
        tools.add(Material.WARPED_FUNGUS_ON_A_STICK);
        return tools;
    }

    public static List<Material> getAllWeapons() {
        ArrayList<Material> weapons = new ArrayList<Material>();
        weapons.addAll(Tag.ITEMS_SWORDS.getValues());
        weapons.add(Material.BOW);
        weapons.add(Material.CROSSBOW);
        weapons.add(Material.TRIDENT);
        weapons.add(Material.MACE);
        return weapons;
    }

    public static List<Material> getAllArmor() {
        ArrayList<Material> armor = new ArrayList<Material>();
        armor.addAll(Tag.ITEMS_HEAD_ARMOR.getValues());
        armor.addAll(Tag.ITEMS_CHEST_ARMOR.getValues());
        armor.add(Material.ELYTRA);
        armor.addAll(Tag.ITEMS_LEG_ARMOR.getValues());
        armor.addAll(Tag.ITEMS_FOOT_ARMOR.getValues());
        return armor;
    }
}

