/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import me.teakivy.teakstweaks.TeaksTweaks;

public class JsonManager {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static Gson getGson() {
        return gson;
    }

    public static LinkedHashMap<String, Object> getFromFile(String path) {
        return JsonManager.getFromFile(new File(String.valueOf(TeaksTweaks.getInstance().getDataFolder()) + "/" + path));
    }

    public static LinkedHashMap<String, Object> getFromFile(File file) {
        if (!file.exists()) {
            return new LinkedHashMap<String, Object>();
        }
        try {
            LinkedHashMap json = (LinkedHashMap)TeaksTweaks.getGson().fromJson((Reader)new FileReader(file), LinkedHashMap.class);
            return json;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new LinkedHashMap<String, Object>();
        }
    }

    public static LinkedHashMap<String, Object> get(String path) {
        LinkedHashMap<String, Object> json = JsonManager.getFromFile(path);
        if (json == null) {
            return JsonManager.getFromResource(path);
        }
        return json;
    }

    public static LinkedHashMap<String, Object> getFromResource(String path) {
        return (LinkedHashMap)TeaksTweaks.getGson().fromJson((Reader)new InputStreamReader(TeaksTweaks.getInstance().getResource(path)), LinkedHashMap.class);
    }

    public static void saveToFile(LinkedHashMap<String, Object> json, String path) {
        JsonManager.saveToFile(json, new File(String.valueOf(TeaksTweaks.getInstance().getDataFolder()) + "/" + path));
    }

    public static void saveToFile(LinkedHashMap<String, Object> json, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            TeaksTweaks.getGson().toJson(json, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LinkedHashMap<String, Object> updateJson(LinkedHashMap<String, Object> from, LinkedHashMap<String, Object> to, boolean safe) {
        if (!safe) {
            return to;
        }
        LinkedHashMap<String, Object> newJson = new LinkedHashMap<String, Object>();
        for (String key : to.keySet()) {
            if (from.containsKey(key)) {
                newJson.put(key, from.get(key));
                continue;
            }
            newJson.put(key, to.get(key));
        }
        return newJson;
    }
}

