/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.ErrorType;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.register.TTCommand;
import me.teakivy.teakstweaks.utils.register.TTPack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;

public abstract class AbstractCommand {
    private final TTPack parentPack;
    private final String translationKey;
    private final List<String> aliases;
    private TTCommand command;
    private int cooldownTime;
    private final HashMap<UUID, Long> cooldownMap;

    public AbstractCommand(TTCommand command, String translationKey) {
        this(command, translationKey, List.of());
    }

    public AbstractCommand(TTPack parentPack, String translationKey) {
        this(parentPack, translationKey, List.of());
    }

    public AbstractCommand(TTPack parentPack, String translationKey, List<String> aliases) {
        this.parentPack = parentPack;
        this.translationKey = translationKey;
        this.aliases = aliases;
        this.cooldownMap = new HashMap();
        this.cooldownTime = 0;
    }

    public AbstractCommand(TTCommand command, String translationKey, List<String> aliases) {
        this.parentPack = command.getParentPack();
        this.translationKey = translationKey;
        this.aliases = aliases;
        this.command = command;
        this.cooldownMap = new HashMap();
        this.cooldownTime = 0;
    }

    public abstract LiteralCommandNode<CommandSourceStack> getCommand();

    public TTPack getParentPack() {
        return this.parentPack;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Component getText(String key, ComponentLike ... args) {
        return Component.translatable((String)(this.translationKey + "." + key), (ComponentLike[])args);
    }

    public Component getError(String key, ComponentLike ... args) {
        return Component.translatable((String)(this.translationKey + ".error." + key), (ComponentLike[])args);
    }

    public Component get(String key, ComponentLike ... args) {
        return Component.translatable((String)key, (ComponentLike[])args);
    }

    public ConfigurationSection getPackConfig() {
        return Config.getPackConfig(this.parentPack.getKey());
    }

    public ConfigurationSection getConfig() {
        return Config.get();
    }

    public ComponentLike insert(@Subst(value="") String key, Object value) {
        return Argument.component((String)key, (ComponentLike)Component.text((String)value.toString()));
    }

    public ComponentLike insert(@Subst(value="") String key, Component value) {
        return Argument.component((String)key, (ComponentLike)value);
    }

    public JavaPlugin getPlugin() {
        return TeaksTweaks.getInstance();
    }

    public void register() {
        if (this.parentPack != null && !Config.isPackEnabled(this.parentPack.getKey()) && !Config.isDevMode()) {
            return;
        }
        this.getPlugin().getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(this.getCommand(), this.aliases));
    }

    public boolean isEnabled() {
        return this.parentPack == null || Config.isPackEnabled(this.parentPack.getKey()) || Config.isDevMode();
    }

    protected Command<CommandSourceStack> playerOnly(Function<CommandContext<CommandSourceStack>, Integer> function) {
        return context -> {
            if (!(((CommandSourceStack)context.getSource()).getSender() instanceof Player)) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(ErrorType.NOT_PLAYER.m());
                return 1;
            }
            return (Integer)function.apply(context);
        };
    }

    protected Player checkPlayer(CommandContext<CommandSourceStack> ctx) {
        if (!(((CommandSourceStack)ctx.getSource()).getSender() instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(ErrorType.NOT_PLAYER.m());
            return null;
        }
        return (Player)((CommandSourceStack)ctx.getSource()).getSender();
    }

    protected Predicate<CommandSourceStack> perm(Permission permission) {
        return source -> source.getSender().hasPermission(permission.getPermission());
    }

    public void setCooldownTime(int time) {
        this.cooldownTime = time;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public void setCooldown(Player player) {
        this.cooldownMap.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void resetCooldown(Player player) {
        this.cooldownMap.remove(player.getUniqueId());
    }

    public boolean isOnCooldown(Player player) {
        if (!this.cooldownMap.containsKey(player.getUniqueId())) {
            return false;
        }
        return this.cooldownMap.get(player.getUniqueId()) + (long)this.cooldownTime * 1000L > System.currentTimeMillis();
    }

    public int getCooldown(Player player) {
        if (!this.cooldownMap.containsKey(player.getUniqueId())) {
            return 0;
        }
        return (int)((this.cooldownMap.get(player.getUniqueId()) + (long)this.cooldownTime * 1000L - System.currentTimeMillis()) / 1000L);
    }

    public static SuggestionProvider<CommandSourceStack> createSuggestions(List<String> suggestions) {
        return (ctx, builder) -> {
            builder.restart();
            String remaining = builder.getRemainingLowerCase();
            for (String suggestion : suggestions) {
                if (!suggestion.toLowerCase().startsWith(remaining)) continue;
                builder.suggest(suggestion);
            }
            return builder.buildFuture();
        };
    }
}

