/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.config.ConfigUpdater;
import me.teakivy.teakstweaks.utils.log.Logger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class Config {
    public static void init() {
        TeaksTweaks.getInstance().saveDefaultConfig();
        Config.updateConfig();
    }

    public static ConfigurationSection get() {
        return TeaksTweaks.getInstance().getConfig();
    }

    public static boolean isPackEnabled(String pack) {
        return Config.getBoolean("packs." + pack + ".enabled");
    }

    public static boolean isCraftingTweakEnabled(String tweak) {
        return Config.getBoolean("crafting-tweaks." + tweak + ".enabled");
    }

    public static ConfigurationSection getPackConfig(String pack) {
        return Config.get().getConfigurationSection("packs." + pack);
    }

    public static boolean isDevMode() {
        return Config.getBoolean("config.dev-mode");
    }

    public static String getVersion() {
        return Config.getString("config.version");
    }

    public static String getCreatedVersion() {
        return Config.getString("config.created-version");
    }

    private static void updateConfig() {
        try {
            ConfigUpdater.update((Plugin)TeaksTweaks.getInstance(), "config.yml", new File(TeaksTweaks.getInstance().getDataFolder(), "config.yml"), Collections.emptyList(), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Logger.info(MiniMessage.miniMessage().deserialize((Object)"<yellow>Updated Plugin Config"));
    }

    public static int getInt(String path) {
        return Config.get().getInt(path);
    }

    public static boolean getBoolean(String path) {
        return Config.get().getBoolean(path);
    }

    public static String getString(String path) {
        return Config.get().getString(path);
    }

    public static String getLanguage() {
        return Config.get().getString("settings.server-language");
    }
}

