/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.gui;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PaginatedGUI {
    private static final HashMap<UUID, PaginatedGUI> guis = new HashMap();
    private int page = 0;
    private final List<ItemStack> items;
    private final Inventory inv;

    public PaginatedGUI(List<ItemStack> items, Component title) {
        this.items = items;
        this.inv = Bukkit.createInventory(null, (int)54, (Component)title);
    }

    public void open(Player player) {
        player.openInventory(this.inv);
        this.update();
        guis.put(player.getUniqueId(), this);
    }

    public void nextPage() {
        if (this.page < this.items.size() / 45) {
            ++this.page;
            this.update();
        }
    }

    public void previousPage() {
        if (this.page > 0) {
            --this.page;
            this.update();
        }
    }

    private void update() {
        int index;
        this.inv.clear();
        for (int i = 0; i < 45 && (index = i + this.page * 45) < this.items.size(); ++i) {
            this.inv.setItem(i, this.items.get(index));
        }
        MiniMessage mm = MiniMessage.miniMessage();
        ItemStack nextButton = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = nextButton.getItemMeta();
        nextMeta.displayName(mm.deserialize((Object)TranslationManager.getString(Config.getLanguage(), "mechanics.gui.next_page")).decoration(TextDecoration.ITALIC, false));
        nextButton.setItemMeta(nextMeta);
        ItemStack prevButton = new ItemStack(Material.ARROW);
        ItemMeta prevMeta = prevButton.getItemMeta();
        prevMeta.displayName(mm.deserialize((Object)TranslationManager.getString(Config.getLanguage(), "mechanics.gui.previous_page")).decoration(TextDecoration.ITALIC, false));
        prevButton.setItemMeta(prevMeta);
        if (this.page < this.items.size() / 45) {
            this.inv.setItem(53, nextButton);
        }
        if (this.page > 0) {
            this.inv.setItem(45, prevButton);
        }
    }

    public static PaginatedGUI getGui(Player player) {
        return guis.get(player.getUniqueId());
    }

    public static void next(Player player) {
        PaginatedGUI gui = PaginatedGUI.getGui(player);
        gui.nextPage();
    }

    public static void previous(Player player) {
        PaginatedGUI gui = PaginatedGUI.getGui(player);
        gui.previousPage();
    }
}

