/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.lang;

import com.destroystokyo.paper.ClientOption;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.log.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslationStore;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.bukkit.entity.Player;

public class TranslationManager {
    private final File dataFolder;
    private final List<String> supportedLanguages = List.of("en_US", "de_DE", "fi_FI", "fr_FR", "nl_NL", "pl_PL", "ru_RU");

    public TranslationManager(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public void initialize() {
        this.saveDefaultTranslations();
        this.loadTranslations();
    }

    private void saveDefaultTranslations() {
        File translationsFolder = new File(this.dataFolder, "translations");
        if (!translationsFolder.exists()) {
            translationsFolder.mkdirs();
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String lang : this.supportedLanguages) {
            File outFile = new File(translationsFolder, lang + ".properties");
            String resourcePath = "translations/" + lang + ".properties";
            Properties jarProps = this.loadPropertiesFromJar(resourcePath);
            if (jarProps == null) {
                Logger.error((Component)Component.text((String)("Missing default translation resource: " + resourcePath)));
                continue;
            }
            if (!outFile.exists()) {
                this.savePropertiesToFile(jarProps, outFile, "Default translation generated");
                Logger.info((Component)Component.text((String)("Created default translation: " + outFile.getName())));
                continue;
            }
            Properties diskProps = this.loadPropertiesFromDisk(outFile);
            if (diskProps == null) {
                Logger.error((Component)Component.text((String)("Failed to read existing translation: " + outFile.getName())));
                continue;
            }
            boolean isModified = Boolean.parseBoolean(diskProps.getProperty("meta.modified", "false"));
            if (!isModified) {
                this.savePropertiesToFile(jarProps, outFile, "Overwritten with new default because meta.modified=false");
                continue;
            }
            Properties merged = new Properties();
            merged.setProperty("meta.modified", "true");
            for (String key : jarProps.stringPropertyNames()) {
                if (key.equalsIgnoreCase("meta.modified")) continue;
                if (diskProps.containsKey(key)) {
                    merged.setProperty(key, diskProps.getProperty(key));
                    continue;
                }
                merged.setProperty(key, jarProps.getProperty(key));
            }
            this.savePropertiesToFile(merged, outFile, "Merged with new keys from JAR; meta.modified kept on top");
            Logger.info((Component)Component.text((String)("Merged translation updates into: " + outFile.getName())));
        }
    }

    private void loadTranslations() {
        MiniMessageTranslationStore store = MiniMessageTranslationStore.create((net.kyori.adventure.key.Key)Key.get("translations"));
        File translationsFolder = new File(this.dataFolder, "translations");
        for (String lang : this.supportedLanguages) {
            String[] parts = lang.split("_");
            String language = parts[0];
            String country = parts[1];
            Locale locale = new Locale(language, country);
            File translationFile = new File(translationsFolder, lang + ".properties");
            if (!translationFile.exists()) {
                Logger.error((Component)Component.text((String)("Translation file not found on disk: " + translationFile.getAbsolutePath())));
                continue;
            }
            Properties properties = new Properties();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(translationFile), StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException e) {
                Logger.error((Component)Component.text((String)("Error reading translation file: " + translationFile.getAbsolutePath())));
                e.printStackTrace();
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : properties.stringPropertyNames()) {
                map.put(key, properties.getProperty(key));
            }
            store.registerAll(locale, map);
            Logger.info((Component)Component.text((String)("Loaded translations for " + lang)));
        }
        GlobalTranslator.translator().addSource((Translator)store);
        Logger.info((Component)Component.text((String)"All translations registered with GlobalTranslator."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFromJar(String resourcePath) {
        Properties props = new Properties();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) {
                Properties properties2 = null;
                return properties2;
            }
            props.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Properties loadPropertiesFromDisk(File file) {
        Properties properties;
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            props.load(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        fis.close();
        return properties;
    }

    private void savePropertiesToFile(Properties props, File file, String comments) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            if (comments != null && !comments.isEmpty()) {
                writer.write("# " + comments);
                writer.newLine();
            }
            String metaValue = props.getProperty("meta.modified", "false");
            writer.write("meta.modified=" + metaValue);
            writer.newLine();
            ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
            Collections.sort(keys);
            for (String key : keys) {
                if (key.equalsIgnoreCase("meta.modified")) continue;
                writer.write(key + "=" + props.getProperty(key));
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getTranslationString(String localeName, String key) {
        if (key == null || localeName == null) {
            return null;
        }
        String[] parts = localeName.split("_");
        String language = parts[0];
        String country = parts.length > 1 ? parts[1] : "";
        Locale locale = new Locale(language, country);
        TranslatableComponent translatable = Component.translatable((String)key);
        Component resolved = GlobalTranslator.translator().translate(translatable, locale);
        if (resolved == null) {
            return null;
        }
        return (String)MiniMessage.miniMessage().serialize(resolved);
    }

    public static String getString(String localeName, String key) {
        String str = TeaksTweaks.getTranslationManager().getTranslationString(localeName, key);
        return str == null ? key : str;
    }

    public static String getString(Player player, String key) {
        String str = TeaksTweaks.getTranslationManager().getTranslationString((String)player.getClientOption(ClientOption.LOCALE), key);
        return str == null ? key : str;
    }
}

