/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.permission.Permission;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;

public class Logger {
    public static void log(LogLevel level, Component message, boolean toAdmins) {
        if (message == null) {
            return;
        }
        String text = "<dark_gray>[<gold><bold>TeaksTweaks</bold></gold>]<reset> " + Logger.getPrefix(level) + " <reset>" + (String)MiniMessage.miniMessage().serialize(message);
        Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)text));
        if (!toAdmins) {
            return;
        }
        Bukkit.getOnlinePlayers().stream().filter(Permission.MANAGE::check).forEach(player -> player.sendMessage(message));
    }

    public static void log(LogLevel level, String message, boolean toAdmins) {
        Logger.log(level, MiniMessage.miniMessage().deserialize((Object)message), toAdmins);
    }

    private static String getPrefix(LogLevel level) {
        String prefix = "";
        switch (level.ordinal()) {
            case 0: {
                prefix = "<dark_gray>[<red><bold>ERROR</bold></red>]";
                break;
            }
            case 1: {
                prefix = "<dark_gray>[<gold><bold>WARNING</bold></gold>]";
                break;
            }
            case 2: {
                prefix = "<dark_gray>[<yellow><bold>INFO</bold></yellow>]";
                break;
            }
            case 3: {
                prefix = "<dark_gray>[<green><bold>SUCCESS</bold></green>]";
                break;
            }
            case 4: {
                prefix = "<dark_gray>[<gray><bold>OUTLINE</bold></gray>]";
            }
        }
        return prefix;
    }

    public static void log(LogLevel level, Component message) {
        Logger.log(level, message, false);
    }

    @Deprecated
    public static void log(LogLevel level, String message) {
        Logger.log(level, message, false);
    }

    public static void error(Component message) {
        Logger.log(LogLevel.ERROR, message);
    }

    @Deprecated
    public static void error(String message) {
        Logger.log(LogLevel.ERROR, message);
    }

    public static void warning(Component message) {
        Logger.log(LogLevel.WARNING, message);
    }

    @Deprecated
    public static void warning(String message) {
        Logger.log(LogLevel.WARNING, message);
    }

    public static void info(Component message) {
        Logger.log(LogLevel.INFO, message);
    }

    @Deprecated
    public static void info(String message) {
        Logger.log(LogLevel.INFO, message);
    }

    public static void success(Component message) {
        Logger.log(LogLevel.SUCCESS, message);
    }

    @Deprecated
    public static void success(String message) {
        Logger.log(LogLevel.SUCCESS, message);
    }

    public static void outline(Component message) {
        Logger.log(LogLevel.OUTLINE, message);
    }

    @Deprecated
    public static void outline(String message) {
        Logger.log(LogLevel.OUTLINE, message);
    }

    public static String getLogMessagesAsString() {
        File file = TeaksTweaks.getInstance().getServer().getWorldContainer().toPath().resolve("logs/latest.log").toFile();
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        SUCCESS,
        OUTLINE;

    }
}

