/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.metrics.Metrics;

public class CustomMetrics {
    private static final HashMap<String, Integer> enabledPacks = new HashMap();
    private static final HashMap<String, Integer> enabledCraftingTweaks = new HashMap();

    public static void addPackEnabled(String pack) {
        enabledPacks.put(pack, 1);
    }

    public static void addCraftingTweakEnabled(String tweak) {
        enabledCraftingTweaks.put(tweak, 1);
    }

    public static void registerCustomMetrics(Metrics metrics) {
        CustomMetrics.registerPackMetrics(metrics);
        CustomMetrics.registerCraftingTweaksMetrics(metrics);
        CustomMetrics.registerFirstUsedMetrics(metrics);
        CustomMetrics.registerDevModeMetrics(metrics);
        metrics.addCustomChart(new Metrics.AdvancedPie("server-language", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                String languageCode = Config.getLanguage();
                String language = "Unknown";
                valueMap.put(language + " ( " + languageCode + " )", 1);
                return valueMap;
            }
        }));
    }

    public static void registerPackMetrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("packs", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                return enabledPacks;
            }
        }));
    }

    public static void registerCraftingTweaksMetrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("crafting_tweaks", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                return enabledCraftingTweaks;
            }
        }));
    }

    public static void registerFirstUsedMetrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("first_used", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                valueMap.put(Config.getCreatedVersion(), 1);
                return valueMap;
            }
        }));
    }

    public static void registerDevModeMetrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("dev_mode", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Config.isDevMode()) {
                    valueMap.put("Enabled", 1);
                } else {
                    valueMap.put("Disabled", 1);
                }
                return valueMap;
            }
        }));
    }
}

