/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.miniblock;

import java.net.MalformedURLException;
import java.util.UUID;
import me.teakivy.teakstweaks.packs.moremobheads.MoreMobHeads;
import me.teakivy.teakstweaks.utils.Key;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.customitems.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class MiniBlockTrade {
    private final String name;
    private final String texture;
    private final Material material;

    public MiniBlockTrade(String name, String texture, Material material) {
        this.name = name;
        this.texture = texture;
        this.material = material;
        ItemStack head = this.getSkull(1);
        CustomItem customItem = new CustomItem(name.toLowerCase().replaceAll(" ", "_") + "_mini_block", head);
        customItem.register();
    }

    public MerchantRecipe getMerchantTrade() {
        MerchantRecipe recipe = new MerchantRecipe(this.getSkull(Config.getInt("packs.wandering-trades.mini-blocks.per-trade")), Config.getInt("packs.wandering-trades.mini-blocks.amount-of-trades"));
        recipe.addIngredient(new ItemStack(Material.EMERALD, 1));
        recipe.addIngredient(new ItemStack(this.material));
        return recipe;
    }

    public StonecuttingRecipe getStonecuttingRecipe() {
        String n = this.name.toLowerCase().replaceAll(" ", "_");
        return new StonecuttingRecipe(Key.get("sc_mini_blocks_" + n), this.getSkull(Config.getInt("packs.mini-blocks.per-cut")), this.material);
    }

    public ItemStack getSkull(int amount) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, amount);
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.fromString("fdb5599c-1b14-440e-82df-d69719703d21"), (String)"MiniBlock");
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.RESET) + this.name + " Mini Block");
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(MoreMobHeads.getUrlFromBase64(this.texture));
        }
        catch (MalformedURLException var8) {
            var8.printStackTrace();
        }
        meta.setOwnerProfile(profile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

