/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.miniblock;

import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.JsonManager;
import me.teakivy.teakstweaks.utils.miniblock.MiniBlockTrade;
import org.bukkit.Material;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class MiniBlockUtils {
    static List<MiniBlockTrade> miniBlocks = new ArrayList<MiniBlockTrade>();

    public static void load() {
        JsonManager.saveToFile(JsonManager.updateJson(JsonManager.getFromFile("data/mini_blocks.json"), JsonManager.getFromResource("data/mini_blocks.json"), true), "data/mini_blocks.json");
        File file = new File(String.valueOf(TeaksTweaks.getInstance().getDataFolder()) + "/data/mini_blocks.json");
        if (!file.exists()) {
            TeaksTweaks.getInstance().saveResource("data/mini_blocks.json", false);
        }
        if (!(file = new File(String.valueOf(TeaksTweaks.getInstance().getDataFolder()) + "/data/mini_blocks.json")).exists()) {
            miniBlocks = new ArrayList<MiniBlockTrade>();
        }
        try {
            LinkedHashMap map = (LinkedHashMap)TeaksTweaks.getGson().fromJson((Reader)new FileReader(file), LinkedHashMap.class);
            for (Object mini_block : (List)map.get("mini_blocks")) {
                LinkedTreeMap mini_block_map = (LinkedTreeMap)mini_block;
                String name = (String)mini_block_map.get((Object)"name");
                String texture = (String)mini_block_map.get((Object)"texture");
                Material material = Material.matchMaterial((String)mini_block_map.get((Object)"id").toString().toUpperCase());
                miniBlocks.add(new MiniBlockTrade(name, texture, material));
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            miniBlocks = new ArrayList<MiniBlockTrade>();
            return;
        }
    }

    public static List<MiniBlockTrade> getMiniBlocks() {
        if (miniBlocks.isEmpty()) {
            MiniBlockUtils.load();
        }
        return miniBlocks;
    }

    public static List<MerchantRecipe> getAllMerchantRecipes() {
        if (miniBlocks.isEmpty()) {
            MiniBlockUtils.load();
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        for (MiniBlockTrade miniBlock : miniBlocks) {
            recipes.add(miniBlock.getMerchantTrade());
        }
        return recipes;
    }

    public static List<StonecuttingRecipe> getAllStonecuttingRecipes() {
        if (miniBlocks.isEmpty()) {
            MiniBlockUtils.load();
        }
        ArrayList<StonecuttingRecipe> recipes = new ArrayList<StonecuttingRecipe>();
        for (MiniBlockTrade miniBlock : miniBlocks) {
            recipes.add(miniBlock.getStonecuttingRecipe());
        }
        return recipes;
    }
}

