/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.recipe;

import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Recipe;

public class RecipeData {
    private final String parent;
    private final NamespacedKey key;
    private final Recipe recipe;

    public RecipeData(String parent, Recipe recipe) {
        this.parent = parent;
        this.recipe = recipe;
        this.key = ((Keyed)recipe).getKey();
    }

    public String getParent() {
        return this.parent;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public void grantRecipe() {
        this.register();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.grantRecipe(player);
        }
    }

    public void grantRecipe(Player player) {
        this.register();
        if (player.hasDiscoveredRecipe(this.key)) {
            return;
        }
        player.discoverRecipe(this.key);
    }

    public void revokeRecipe() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.revokeRecipe(player);
        }
    }

    public void revokeRecipe(Player player) {
        if (!player.hasDiscoveredRecipe(this.key)) {
            return;
        }
        player.undiscoverRecipe(this.key);
    }

    public void register() {
        if (Bukkit.getRecipe((NamespacedKey)this.key) != null) {
            return;
        }
        Bukkit.addRecipe((Recipe)this.recipe);
        this.grantRecipe();
    }

    public void unregister() {
        Bukkit.removeRecipe((NamespacedKey)this.key);
        this.revokeRecipe();
    }
}

