/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.recipe;

import java.util.ArrayList;
import java.util.List;
import me.teakivy.teakstweaks.utils.recipe.RecipeData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Recipe;

public class RecipeManager
implements Listener {
    private static final List<RecipeData> recipes = new ArrayList<RecipeData>();

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        for (RecipeData recipe : recipes) {
            recipe.grantRecipe(event.getPlayer());
        }
    }

    public static void register(RecipeData recipe) {
        recipes.add(recipe);
        recipe.register();
    }

    public static void register(List<RecipeData> recipes) {
        for (RecipeData recipe : recipes) {
            RecipeManager.register(recipe);
        }
    }

    public static void register(String parent, Recipe recipe) {
        RecipeManager.register(new RecipeData(parent, recipe));
    }

    public static void register(String parent, List<Recipe> recipes) {
        ArrayList<RecipeData> recipeData = new ArrayList<RecipeData>();
        for (Recipe recipe : recipes) {
            recipeData.add(new RecipeData(parent, recipe));
        }
        RecipeManager.register(recipeData);
    }

    public static void unregister(RecipeData recipe) {
        recipes.remove(recipe);
        recipe.unregister();
    }

    public static void unregister(List<RecipeData> recipes) {
        for (RecipeData recipe : recipes) {
            RecipeManager.unregister(recipe);
        }
    }

    public static void unregister(String parent) {
        List<RecipeData> toRemove = RecipeManager.getRecipes(parent);
        RecipeManager.unregister(toRemove);
    }

    public static void unregisterAll() {
        RecipeManager.unregister(new ArrayList<RecipeData>(recipes));
    }

    public static List<RecipeData> getRecipes() {
        return recipes;
    }

    public static List<RecipeData> getRecipes(String parent) {
        ArrayList<RecipeData> parentRecipes = new ArrayList<RecipeData>();
        for (RecipeData recipe : recipes) {
            if (!recipe.getParent().equals(parent)) continue;
            parentRecipes.add(recipe);
        }
        return parentRecipes;
    }
}

