/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.register;

import java.lang.reflect.Constructor;
import me.teakivy.teakstweaks.commands.AFKCommand;
import me.teakivy.teakstweaks.commands.AltsCommand;
import me.teakivy.teakstweaks.commands.BackCommand;
import me.teakivy.teakstweaks.commands.BedCommand;
import me.teakivy.teakstweaks.commands.ConduitPowerCommand;
import me.teakivy.teakstweaks.commands.CoordsHudCommand;
import me.teakivy.teakstweaks.commands.DeleteHomeCommand;
import me.teakivy.teakstweaks.commands.DisposalCommand;
import me.teakivy.teakstweaks.commands.DurabilityPingCommand;
import me.teakivy.teakstweaks.commands.GraveCommand;
import me.teakivy.teakstweaks.commands.HomeCommand;
import me.teakivy.teakstweaks.commands.ItemAveragesCommand;
import me.teakivy.teakstweaks.commands.KillBoatsCommand;
import me.teakivy.teakstweaks.commands.MechanicsCommand;
import me.teakivy.teakstweaks.commands.NightVisionCommand;
import me.teakivy.teakstweaks.commands.PortalCommand;
import me.teakivy.teakstweaks.commands.RealTimeClockCommand;
import me.teakivy.teakstweaks.commands.SetHomeCommand;
import me.teakivy.teakstweaks.commands.ShrineCommand;
import me.teakivy.teakstweaks.commands.SpawnCommand;
import me.teakivy.teakstweaks.commands.SpawningSpheresCommand;
import me.teakivy.teakstweaks.commands.SudokuCommand;
import me.teakivy.teakstweaks.commands.TPACommand;
import me.teakivy.teakstweaks.commands.TPAHereCommand;
import me.teakivy.teakstweaks.commands.TeaksTweaksCommand;
import me.teakivy.teakstweaks.commands.TestCommand;
import me.teakivy.teakstweaks.commands.WorkstationHighlightCommand;
import me.teakivy.teakstweaks.utils.command.AbstractCommand;
import me.teakivy.teakstweaks.utils.register.TTPack;

public enum TTCommand {
    AFK("afk", AFKCommand.class, TTPack.AFK_DISPLAY),
    ALTS("alts", AltsCommand.class, TTPack.SPECTATOR_ALTS),
    BACK("back", BackCommand.class, TTPack.BACK),
    BED("bed", BedCommand.class, TTPack.BACK_TO_BED),
    CONDUITPOWER("conduitpower", ConduitPowerCommand.class, TTPack.SPECTATOR_CONDUIT_POWER),
    COORDSHUD("coordshud", CoordsHudCommand.class, TTPack.COORDS_HUD),
    DELETEHOME("deletehome", DeleteHomeCommand.class, TTPack.HOMES),
    DISPOSAL("disposal", DisposalCommand.class, TTPack.DISPOSAL),
    DURABILITYPING("durabilityping", DurabilityPingCommand.class, TTPack.DURABILITY_PING),
    GRAVE("grave", GraveCommand.class, TTPack.GRAVES),
    HOME("home", HomeCommand.class, TTPack.HOMES),
    ITEMAVERAGES("itemaverages", ItemAveragesCommand.class, TTPack.ITEM_AVERAGES),
    KILLBOATS("killboats", KillBoatsCommand.class, TTPack.KILL_BOATS),
    NIGHTVISION("nightvision", NightVisionCommand.class, TTPack.SPECTATOR_NIGHT_VISION),
    PORTAL("portal", PortalCommand.class, TTPack.NETHER_PORTAL_COORDS),
    REALTIMECLOCK("realtimeclock", RealTimeClockCommand.class, TTPack.REAL_TIME_CLOCK),
    SETHOME("sethome", SetHomeCommand.class, TTPack.HOMES),
    SHRINE("shrine", ShrineCommand.class, TTPack.THUNDER_SHRINE),
    SPAWN("spawn", SpawnCommand.class, TTPack.SPAWN),
    SPAWNINGSPHERES("spawningspheres", SpawningSpheresCommand.class, TTPack.SPAWNING_SPHERES),
    SUDOKU("sudoku", SudokuCommand.class, TTPack.SUDOKU),
    TPA("tpa", TPACommand.class, TTPack.TPA),
    TPAHERE("tpahere", TPAHereCommand.class, TTPack.TPA),
    WORKSTATIONHIGHLIGHT("workstationhighlight", WorkstationHighlightCommand.class, TTPack.WORKSTATION_HIGHLIGHTS),
    MECHANICS("mechanics", MechanicsCommand.class),
    TEST("test", TestCommand.class),
    TEAKSTWEAKS("teakstweaks", TeaksTweaksCommand.class);

    private final String name;
    private final Class<? extends AbstractCommand> clazz;
    private final TTPack parentPack;
    private AbstractCommand command;

    private TTCommand(String name, Class<? extends AbstractCommand> clazz, TTPack parentPack) {
        this.name = name;
        this.clazz = clazz;
        this.parentPack = parentPack;
    }

    private TTCommand(String name, Class<? extends AbstractCommand> clazz) {
        this(name, clazz, null);
    }

    public String getName() {
        return this.name;
    }

    public TTPack getParentPack() {
        return this.parentPack;
    }

    public AbstractCommand getCommand() {
        if (this.command == null) {
            this.instantiate();
        }
        return this.command;
    }

    private void instantiate() {
        try {
            Constructor<? extends AbstractCommand> constructor = this.clazz.getConstructor(new Class[0]);
            this.command = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate command: " + this.name, e);
        }
    }

    public static TTCommand fromName(String name) {
        for (TTCommand command : TTCommand.values()) {
            if (!command.getName().equalsIgnoreCase(name)) continue;
            return command;
        }
        return null;
    }

    public void register() {
        if (this.parentPack != null && !this.parentPack.isEnabled()) {
            return;
        }
        this.getCommand().register();
    }

    public boolean isEnabled() {
        return this.getCommand().isEnabled();
    }

    public String toString() {
        return this.name;
    }
}

