/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.update;

import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.log.Logger;
import me.teakivy.teakstweaks.utils.update.Version;
import me.teakivy.teakstweaks.utils.update.VersionManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.translation.Argument;

public class UpdateChecker {
    public static boolean hasUpdate() {
        Version latestVersion = VersionManager.getBestVersion();
        if (latestVersion == null) {
            return false;
        }
        Version currentVersion = new Version(TeaksTweaks.getInstance().getDescription().getVersion());
        return latestVersion.isNewerThan(currentVersion);
    }

    public static void sendUpdateMessage() {
        if (UpdateChecker.hasUpdate()) {
            Version latestVersion = VersionManager.getBestVersion();
            if (latestVersion == null) {
                return;
            }
            Logger.info((Component)Component.translatable((String)"startup.update.version_available", (ComponentLike[])new ComponentLike[]{Argument.string((String)"version", (String)latestVersion.getVersion())}));
            Logger.info((Component)Component.translatable((String)"startup.update.download", (ComponentLike[])new ComponentLike[]{Argument.string((String)"url", (String)latestVersion.getUrl())}));
        }
    }
}

