/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.update;

import com.destroystokyo.paper.ClientOption;
import me.teakivy.teakstweaks.TeaksTweaks;
import me.teakivy.teakstweaks.utils.config.Config;
import me.teakivy.teakstweaks.utils.lang.TranslationManager;
import me.teakivy.teakstweaks.utils.permission.Permission;
import me.teakivy.teakstweaks.utils.update.UpdateChecker;
import me.teakivy.teakstweaks.utils.update.Version;
import me.teakivy.teakstweaks.utils.update.VersionManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateJoinAlert
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!Permission.MANAGE.check((CommandSender)player)) {
            return;
        }
        if (!Config.getBoolean("settings.alert-on-new-version")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TeaksTweaks.getInstance(), () -> {
            if (!UpdateChecker.hasUpdate()) {
                return;
            }
            Version latestVersion = VersionManager.getBestVersion();
            if (latestVersion == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)TeaksTweaks.getInstance(), () -> {
                Object message = TranslationManager.getString((String)player.getClientOption(ClientOption.LOCALE), "startup.update.join_alert");
                message = "<hover:show_text:\"" + TranslationManager.getString((String)player.getClientOption(ClientOption.LOCALE), "startup.update.join_alert.hover") + "\">" + (String)message;
                message = "<click:open_url:\"" + latestVersion.getUrl() + "\">" + (String)message;
                player.sendMessage(MiniMessage.miniMessage().deserialize((String)message, (TagResolver)Placeholder.parsed((String)"version", (String)latestVersion.getVersion())));
                player.sendMessage("");
            });
        });
    }
}

