/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.update;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;

public class Version {
    private final String version;
    private final List<String> supportedMCVersions;
    private final String id;

    public Version(String version, List<String> supportedMCVersions, String id) {
        this.version = version;
        this.supportedMCVersions = supportedMCVersions;
        this.id = id;
    }

    public Version(String version, String id) {
        this.version = version;
        this.supportedMCVersions = new ArrayList<String>();
        this.id = id;
    }

    public Version(String version) {
        this.version = version;
        this.supportedMCVersions = new ArrayList<String>();
        this.id = "";
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getSupportedMCVersions() {
        return this.supportedMCVersions;
    }

    public String getUrl() {
        return "https://modrinth.com/plugin/teaks-tweaks/version/" + this.id;
    }

    public boolean isSupported() {
        String mcVersion = Bukkit.getBukkitVersion().split("-")[0];
        return this.supportedMCVersions.contains(mcVersion);
    }

    public void addSupportedMCVersion(String version) {
        this.supportedMCVersions.add(version);
    }

    private int getMajorVersion() {
        return Integer.parseInt(this.version.split("\\.")[0]);
    }

    private int getMinorVersion() {
        return Integer.parseInt(this.version.split("\\.")[1]);
    }

    private int getPatchVersion() {
        return Integer.parseInt(this.version.split("\\.")[2].split("-")[0]);
    }

    public boolean isNewerThan(Version v) {
        if (v.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (this.getMajorVersion() != v.getMajorVersion()) {
            return this.getMajorVersion() > v.getMajorVersion();
        }
        if (this.getMinorVersion() != v.getMinorVersion()) {
            return this.getMinorVersion() > v.getMinorVersion();
        }
        if (this.getPatchVersion() != v.getPatchVersion()) {
            return this.getPatchVersion() > v.getPatchVersion();
        }
        return this.getSupportedMCVersions().size() < v.getSupportedMCVersions().size();
    }
}

